/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Locale;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.ironchests.api.chesttype.ChestBlockType;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.client.IronChestsClient;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlock;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;
import tech.thatgravyboat.ironchests.common.blocks.LockState;

public class ChestRenderer<T extends GenericChestBlockEntity>
implements BlockEntityRenderer<T> {
    private BakedModel lid;
    private BakedModel base;
    private static BakedModel lockUnlocked;
    private static BakedModel lockLocked;
    private final ChestType type;

    public ChestRenderer(ChestType type) {
        this.type = type;
    }

    public void render(@NotNull T chest, float f, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int i, int j) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("ironchestRenderer");
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        this.initModels(blockRenderer);
        if (!(chest.m_58900_().m_60734_() instanceof GenericChestBlock)) {
            return;
        }
        poseStack.m_85836_();
        RenderSystem.enableDepthTest();
        poseStack.m_85837_(0.5, 1.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)chest.m_58900_().m_61143_(GenericChestBlock.getFacingProperty(this.type))).m_122435_()));
        poseStack.m_85837_(-0.5, -1.0, -0.5);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.63, 0.065);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-((GenericChestBlockEntity)chest).getOpenness(f)));
        poseStack.m_85837_(0.0, -0.63, -0.065);
        if (this.type.blockType() == ChestBlockType.CHEST) {
            RenderType renderType = this.type.transparent() ? Sheets.m_110792_() : Sheets.m_110790_();
            ChestRenderer.renderBlock(poseStack, multiBufferSource, renderType, this.lid, i);
            poseStack.m_85849_();
            ChestRenderer.renderBlock(poseStack, multiBufferSource, renderType, this.base, i);
            if (((LockState)((Object)chest.m_58900_().m_61143_(GenericChestBlock.LOCK))).equals((Object)LockState.LOCKED)) {
                ChestRenderer.renderBlock(poseStack, multiBufferSource, Sheets.m_110790_(), lockLocked, i);
            } else if (((LockState)((Object)chest.m_58900_().m_61143_(GenericChestBlock.LOCK))).equals((Object)LockState.UNLOCKED)) {
                ChestRenderer.renderBlock(poseStack, multiBufferSource, Sheets.m_110790_(), lockUnlocked, i);
            }
        } else {
            poseStack.m_85849_();
        }
        profiler.m_6180_("renderItems");
        if (this.type.renderItems() && (((GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_()).equals((Object)GraphicsStatus.FABULOUS) || ((GenericChestBlockEntity)chest).getOpenness(f) > 0.0f || this.type.blockType() != ChestBlockType.CHEST)) {
            this.renderItems(poseStack, (GenericChestBlockEntity)chest, f, multiBufferSource, i);
        }
        profiler.m_7238_();
        poseStack.m_85849_();
        profiler.m_7238_();
    }

    private static void renderBlock(PoseStack poseStack, MultiBufferSource multiBufferSource, RenderType renderType, BakedModel model, int i) {
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), multiBufferSource.m_6299_(renderType), null, model, 1.0f, 1.0f, 1.0f, i, OverlayTexture.f_118083_);
    }

    private void initModels(BlockRenderDispatcher dispatcher) {
        if (this.base == null) {
            this.base = IronChestsClient.loadModel(dispatcher, new ResourceLocation("ironchests", "block/chests/" + this.type.name().toLowerCase(Locale.ROOT) + "_chest_base"));
        }
        if (this.lid == null) {
            this.lid = IronChestsClient.loadModel(dispatcher, new ResourceLocation("ironchests", "block/chests/" + this.type.name().toLowerCase(Locale.ROOT) + "_chest_lid"));
        }
        ChestRenderer.checkAndUpdateLocks(dispatcher);
    }

    private static void checkAndUpdateLocks(BlockRenderDispatcher dispatcher) {
        if (lockUnlocked == null) {
            lockUnlocked = IronChestsClient.loadModel(dispatcher, new ResourceLocation("ironchests", "block/unlocked"));
        }
        if (lockLocked == null) {
            lockLocked = IronChestsClient.loadModel(dispatcher, new ResourceLocation("ironchests", "block/locked"));
        }
    }

    private void renderItems(PoseStack poseStack, GenericChestBlockEntity blockEntity, float tickDelta, MultiBufferSource vertexConsumers, int light) {
        NonNullList<ItemStack> inv = blockEntity.m_7086_();
        poseStack.m_85837_(0.26, 0.2, 0.26);
        if (blockEntity.m_58904_() == null) {
            return;
        }
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (((ItemStack)inv.get(index)).m_41720_() != Items.f_41852_) {
                    this.renderItem(0.24 * (double)i, 0.0, 0.24 * (double)j, (ItemStack)inv.get(index), poseStack, (float)blockEntity.m_58904_().m_46467_() + tickDelta, vertexConsumers, light);
                }
                if (((ItemStack)inv.get(++index)).m_41720_() != Items.f_41852_) {
                    this.renderItem(0.24 * (double)i, 0.2f, 0.24 * (double)j, (ItemStack)inv.get(index), poseStack, (float)blockEntity.m_58904_().m_46467_() + tickDelta, vertexConsumers, light);
                }
                ++index;
            }
        }
    }

    private void renderItem(double x, double y, double z, ItemStack stack, PoseStack matrices, float rotation, MultiBufferSource vertexConsumers, int light) {
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        matrices.m_85836_();
        matrices.m_85837_(x, y, z);
        matrices.m_85841_(0.5f, 0.5f, 0.5f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotation));
        renderer.m_269128_(stack, ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, matrices, vertexConsumers, (Level)Minecraft.m_91087_().f_91073_, 0);
        matrices.m_85849_();
    }
}

