/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.client;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.client.ChestRenderer;
import tech.thatgravyboat.ironchests.client.ChestScreen;
import tech.thatgravyboat.ironchests.client.forge.IronChestsClientImpl;
import tech.thatgravyboat.ironchests.common.items.DollyItem;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestTypeRegistry;
import tech.thatgravyboat.ironchests.common.registry.minecraft.ItemRegistry;

public class IronChestsClient {
    public static void init() {
        for (ChestType value : ChestTypeRegistry.INSTANCE.getChests().values()) {
            IronChestsClient.registerScreen(value.registries().getMenu().get(), ChestScreen::new);
            IronChestsClient.registerEntityRenderer(value.registries().getBlockEntity().get(), context -> new ChestRenderer(value));
            if (!value.transparent()) continue;
            IronChestsClient.setRenderLayer((Block)value.registries().getBlock().get(), RenderType.m_110466_());
        }
        IronChestsClient.registerItemProperty(ItemRegistry.DIAMOND_DOLLY.get(), new ResourceLocation("ironchests", "dolly_filled"), (itemStack, clientLevel, livingEntity, i) -> DollyItem.getChestId(itemStack));
        IronChestsClient.registerItemProperty(ItemRegistry.IRON_DOLLY.get(), new ResourceLocation("ironchests", "dolly_filled"), (itemStack, clientLevel, livingEntity, i) -> DollyItem.getChestId(itemStack));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setRenderLayer(Block block, RenderType type) {
        void var1_1;
        IronChestsClientImpl.setRenderLayer(block, (RenderType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemProperty(Item pItem, ResourceLocation pName, ClampedItemPropertyFunction pProperty) {
        void var2_2;
        void var1_1;
        IronChestsClientImpl.registerItemProperty(pItem, (ResourceLocation)var1_1, (ClampedItemPropertyFunction)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BakedModel loadModel(BlockRenderDispatcher dispatcher, ResourceLocation path) {
        void var1_1;
        return IronChestsClientImpl.loadModel(dispatcher, (ResourceLocation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <H extends AbstractContainerMenu, S extends Screen> void registerScreen(MenuType<H> type, Factory<H, S> factory) {
        void var1_1;
        IronChestsClientImpl.registerScreen(type, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockEntity> void registerEntityRenderer(BlockEntityType<T> type, BlockEntityRendererProvider<T> provider) {
        void var1_1;
        IronChestsClientImpl.registerEntityRenderer(type, var1_1);
    }

    @FunctionalInterface
    public static interface Factory<H extends AbstractContainerMenu, S extends Screen> {
        @NotNull
        public S create(H var1, Inventory var2, Component var3);
    }
}

