/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.ironchests.api.chesttype.ChestBlockType;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;
import tech.thatgravyboat.ironchests.common.blocks.LockState;
import tech.thatgravyboat.ironchests.common.items.UnlockableItem;
import tech.thatgravyboat.ironchests.common.items.UpgradeItem;
import tech.thatgravyboat.ironchests.common.registry.minecraft.ItemRegistry;

public class GenericChestBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<LockState> LOCK = EnumProperty.m_61587_((String)"lock", LockState.class);
    protected final ChestType type;

    protected GenericChestBlock(ChestType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(GenericChestBlock.getFacingProperty(type), (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(LOCK, (Comparable)((Object)LockState.NO_LOCK))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public static GenericChestBlock create(ChestType type, BlockBehaviour.Properties properties) {
        final ChestType chestType = type;
        return new GenericChestBlock(type, properties){

            protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull StateDefinition.Builder<Block, BlockState> builder) {
                builder.m_61104_(new Property[]{1.getFacingProperty(chestType), WATERLOGGED, LOCK, OPEN});
            }
        };
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider menu = state.m_60750_(level, pos);
        if (menu != null && !this.isBlockedChestByBlock((BlockGetter)level, pos) && ((LockState)((Object)state.m_61143_(LOCK))).canOpen()) {
            player.m_5893_(menu);
        }
        if (!((LockState)((Object)state.m_61143_(LOCK))).canOpen()) {
            player.m_5661_((Component)Component.m_237110_((String)"container.isLocked", (Object[])new Object[]{this.m_49954_()}), true);
            player.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof GenericChestBlockEntity) {
            GenericChestBlockEntity chestBlockEntity = (GenericChestBlockEntity)blockEntity;
            chestBlockEntity.m_58638_(stack.m_41786_());
        }
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean bl) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof GenericChestBlockEntity) {
                GenericChestBlockEntity containerEntity = (GenericChestBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)containerEntity);
                if (containerEntity.canDropLock() && !((LockState)((Object)state.m_61143_(LOCK))).equals((Object)LockState.NO_LOCK)) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)ItemRegistry.LOCK.get().m_7968_());
                }
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, bl);
        }
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return this.type.shape().shape();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new GenericChestBlockEntity(this.type.registries().getMenu().get(), this.type.registries().getBlockEntity().get(), pos, state, this.type);
    }

    public float m_5880_(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        BlockEntity blockEntity;
        if (state.m_61138_(LOCK) && !((LockState)((Object)state.m_61143_(LOCK))).canOpen() && (blockEntity = level.m_7702_(pos)) instanceof GenericChestBlockEntity) {
            GenericChestBlockEntity chest = (GenericChestBlockEntity)blockEntity;
            return player.m_150109_().f_35974_.stream().filter(stack -> stack.m_41720_() instanceof UnlockableItem).anyMatch(item -> ((UnlockableItem)item.m_41720_()).canUseOn(player, (ItemStack)item, chest)) ? super.m_5880_(state, player, level, pos) : 0.001f;
        }
        return super.m_5880_(state, player, level, pos);
    }

    @NotNull
    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_(GenericChestBlock.getFacingProperty(this.type))));
    }

    @NotNull
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_(GenericChestBlock.getFacingProperty(this.type), (Comparable)rotation.m_55954_((Direction)blockState.m_61143_(GenericChestBlock.getFacingProperty(this.type))));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        Direction direction = context.m_8125_().m_122424_();
        if (GenericChestBlock.getFacingProperty(this.type).equals((Object)BlockStateProperties.f_61372_)) {
            direction = context.m_7820_().m_122424_();
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(GenericChestBlock.getFacingProperty(this.type), (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_(LOCK, (Comparable)((Object)LockState.NO_LOCK));
    }

    @NotNull
    public FluidState m_5888_(BlockState blockState) {
        return Boolean.TRUE.equals(blockState.m_61143_((Property)WATERLOGGED)) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    @NotNull
    public BlockState m_7417_(BlockState blockState, @NotNull Direction direction, @NotNull BlockState blockState2, @NotNull LevelAccessor levelAccessor, @NotNull BlockPos blockPos, @NotNull BlockPos blockPos2) {
        if (Boolean.TRUE.equals(blockState.m_61143_((Property)WATERLOGGED))) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    private boolean isBlockedChestByBlock(BlockGetter blockGetter, BlockPos blockPos) {
        if (!this.type.blockType().canBeBlocked()) {
            return false;
        }
        BlockPos blockPos2 = blockPos.m_7494_();
        return blockGetter.m_8055_(blockPos2).m_60796_(blockGetter, blockPos2);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return this.type.blockType() == ChestBlockType.CHEST ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? GenericChestBlock.m_152132_(blockEntityType, this.type.registries().getBlockEntity().get(), GenericChestBlockEntity::lidAnimateTick) : null;
    }

    public void m_213898_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        GenericChestBlockEntity chest;
        ChestType newChest;
        if (level.f_46441_.m_188501_() > 0.05f) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericChestBlockEntity && (newChest = (chest = (GenericChestBlockEntity)blockEntity).getChestType().getOxidizedChest()) != null) {
            UpgradeItem.changeToChest((Level)level, pos, chest, newChest);
        }
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return this.type.oxidizedChest() != null;
    }

    public static Property<Direction> getFacingProperty(ChestType type) {
        return type.blockType() == ChestBlockType.BARREL ? BlockStateProperties.f_61372_ : BlockStateProperties.f_61374_;
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericChestBlockEntity) {
            GenericChestBlockEntity chest = (GenericChestBlockEntity)blockEntity;
            return AbstractContainerMenu.m_38938_((Container)chest);
        }
        return 0;
    }
}

