/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.items;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.api.chesttype.ChestUpgradeType;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;

public class UpgradeItem
extends Item {
    public static final TagKey<Block> REPLACEABLE_CHEST_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("ironchests", "upgradeable_wooden_chests"));
    public final ChestUpgradeType type;

    public UpgradeItem(ChestUpgradeType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericChestBlockEntity) {
            GenericChestBlockEntity chestEntity = (GenericChestBlockEntity)blockEntity;
            if (!chestEntity.m_7525_(context.m_43723_())) {
                return InteractionResult.PASS;
            }
            if (!chestEntity.getChestType().equals(this.type.from())) {
                return InteractionResult.PASS;
            }
            UpgradeItem.changeToChest(level, pos, chestEntity, this.type.to());
            context.m_43722_().m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        BlockState state = level.m_8055_(pos);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chestEntity = (ChestBlockEntity)blockEntity;
            if (ChestBlockEntity.m_59086_((BlockGetter)level, (BlockPos)pos) > 0) {
                return InteractionResult.PASS;
            }
            if (!state.m_204336_(REPLACEABLE_CHEST_TAG)) {
                return InteractionResult.PASS;
            }
            if (this.type.from() != null) {
                return InteractionResult.PASS;
            }
            if (!chestEntity.m_7525_(context.m_43723_())) {
                return InteractionResult.PASS;
            }
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            NonNullList contents = NonNullList.m_122780_((int)chestEntity.m_6643_(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < chestEntity.m_6643_(); ++i) {
                contents.set(i, (Object)chestEntity.m_8020_(i));
            }
            BlockState blockState = this.type.to().registries().getBlock().get().m_152465_(context.m_43725_().m_8055_(pos));
            GenericChestBlockEntity chestBlockEntity = (GenericChestBlockEntity)this.type.to().registries().getBlockEntity().get().m_155264_(context.m_8083_(), blockState);
            Component displayName = chestEntity.m_7770_();
            if (chestBlockEntity == null) {
                return InteractionResult.PASS;
            }
            level.m_46747_(pos);
            level.m_7471_(pos, false);
            level.m_7731_(pos, blockState, 3);
            level.m_151523_((BlockEntity)chestBlockEntity);
            context.m_43722_().m_41774_(1);
            if (displayName != null) {
                chestBlockEntity.m_58638_(displayName);
            }
            chestBlockEntity.m_6520_((NonNullList<ItemStack>)contents);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static void changeToChest(Level level, BlockPos pos, GenericChestBlockEntity chest, ChestType to) {
        if (chest.viewers() > 0) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        NonNullList<ItemStack> contents = chest.m_7086_();
        BlockState blockState = to.registries().getBlock().get().m_152465_(level.m_8055_(pos));
        GenericChestBlockEntity chestBlockEntity = (GenericChestBlockEntity)to.registries().getBlockEntity().get().m_155264_(pos, blockState);
        Component displayName = chest.m_7770_();
        UUID key = chest.getKeyId();
        if (chestBlockEntity == null) {
            return;
        }
        level.m_46747_(pos);
        level.m_7471_(pos, false);
        level.m_7731_(pos, blockState, 3);
        level.m_151523_((BlockEntity)chestBlockEntity);
        if (displayName != null) {
            chestBlockEntity.m_58638_(displayName);
        }
        if (key != null) {
            chestBlockEntity.setLockId(key);
        }
        chestBlockEntity.m_6520_(contents);
    }
}

