/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pathfinder.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.pathfinder.PathfinderMod;
import net.mcreator.pathfinder.procedures.AndesiteButtonProcedure;
import net.mcreator.pathfinder.procedures.CalciteButtonProcedure;
import net.mcreator.pathfinder.procedures.DeepslateBricksButtonProcedure;
import net.mcreator.pathfinder.procedures.DeepslateButtonProcedure;
import net.mcreator.pathfinder.procedures.DioriteButtonProcedure;
import net.mcreator.pathfinder.procedures.DirtButtonProcedure;
import net.mcreator.pathfinder.procedures.GraniteButtonProcedure;
import net.mcreator.pathfinder.procedures.MossyBrickButtonProcedure;
import net.mcreator.pathfinder.procedures.MossyCobbleButtonProcedure;
import net.mcreator.pathfinder.procedures.MudButtonProcedure;
import net.mcreator.pathfinder.procedures.PathButtonProcedure;
import net.mcreator.pathfinder.procedures.PathSizeDecreaseProcedure;
import net.mcreator.pathfinder.procedures.PathSizeIncreaseProcedure;
import net.mcreator.pathfinder.procedures.RedSandButtonProcedure;
import net.mcreator.pathfinder.procedures.SandButtonProcedure;
import net.mcreator.pathfinder.procedures.StoneBricksButtonProcedure;
import net.mcreator.pathfinder.procedures.SturdyCheckOffProcedure;
import net.mcreator.pathfinder.procedures.SturdyCheckOnProcedure;
import net.mcreator.pathfinder.world.inventory.SpadeGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpadeGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SpadeGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SpadeGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SpadeGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SpadeGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SpadeGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SpadeGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            PathSizeIncreaseProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            PathSizeDecreaseProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            PathButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            DirtButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            MudButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SandButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            RedSandButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            MossyCobbleButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            MossyBrickButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            StoneBricksButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            AndesiteButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            GraniteButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            DioriteButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            DeepslateButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            DeepslateBricksButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 15) {
            CalciteButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 16) {
            SturdyCheckOnProcedure.execute((Entity)entity);
        }
        if (buttonID == 17) {
            SturdyCheckOffProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PathfinderMod.addNetworkMessage(SpadeGUIButtonMessage.class, SpadeGUIButtonMessage::buffer, SpadeGUIButtonMessage::new, SpadeGUIButtonMessage::handler);
    }
}

