/*
 * Decompiled with CFR 0.152.
 */
package com.odinokland.constantmusic;

import com.odinokland.constantmusic.ConstantMusicConfig;
import com.odinokland.constantmusic.forge.ConstantMusicImpl;
import com.odinokland.constantmusic.mixin.MusicManagerAccessor;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.network.chat.Component;

public class ConstantMusic {
    public static final String MODID = "constantmusic";
    public static final Path configFile = Paths.get(Platform.getConfigFolder().toString(), "constantmusic.toml");
    private static boolean manualConfigInitialized = false;
    private static int timer = 0;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isClothConfigLoaded() {
        return ConstantMusicImpl.isClothConfigLoaded();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int readValue() {
        return ConstantMusicImpl.readValue();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void writeValue(int value) {
        ConstantMusicImpl.writeValue(value);
    }

    public static int getTimer() {
        if (ConstantMusic.isClothConfigLoaded()) {
            return ConstantMusicConfig.getConfig().timer;
        }
        if (!manualConfigInitialized) {
            try {
                timer = ConstantMusic.readValue();
                manualConfigInitialized = true;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return timer;
    }

    public static void setTimer(int value) {
        if (ConstantMusic.isClothConfigLoaded()) {
            ConstantMusicConfig.setTimer(value);
        } else {
            ConstantMusic.writeValue(value);
            timer = value;
        }
    }

    public static void addDebugText(List<String> texts) {
        MusicManager manager = Minecraft.m_91087_().m_91397_();
        if (manager instanceof MusicManagerAccessor) {
            MusicManagerAccessor accessor = (MusicManagerAccessor)manager;
            SoundInstance currentMusic = accessor.getCurrentMusic();
            if (currentMusic == null) {
                texts.add(Component.m_237110_((String)"constantmusic.debug.timer", (Object[])new Object[]{accessor.getTimer()}).getString());
            } else {
                texts.add(Component.m_237110_((String)"constantmusic.debug.music", (Object[])new Object[]{currentMusic.m_7904_()}).getString());
            }
        }
    }
}

