/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.hamsters.entity;

import com.starfish_studios.hamsters.block.HamsterWheelBlock;
import com.starfish_studios.hamsters.entity.SeatEntity;
import com.starfish_studios.hamsters.entity.common.SearchForItemsGoal;
import com.starfish_studios.hamsters.registry.HamstersBlocks;
import com.starfish_studios.hamsters.registry.HamstersEntityType;
import com.starfish_studios.hamsters.registry.HamstersItems;
import com.starfish_studios.hamsters.registry.HamstersSoundEvents;
import com.starfish_studios.hamsters.registry.HamstersTags;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Hamster
extends TamableAnimal
implements GeoEntity {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.hamster.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.hamster.walk");
    protected static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.sf_nba.hamster.run");
    protected static final RawAnimation SLEEP = RawAnimation.begin().thenLoop("animation.sf_nba.hamster.sleep");
    protected static final RawAnimation STANDING = RawAnimation.begin().thenLoop("animation.sf_nba.hamster.standing");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> EAT_COUNTER = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(HamstersTags.HAMSTER_FOOD);
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_HAND = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WAIT_TIME_BEFORE_RUN = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WAIT_TIME_WHEN_RUNNING = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    HamsterGoToWheelGoal hamsterGoToWheelGoal;

    public Hamster(EntityType<? extends Hamster> entityType, Level level) {
        super(entityType, level);
        if (!this.m_5803_()) {
            this.m_21553_(true);
        }
        this.f_21365_ = new HamsterLookControl();
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_CAUTIOUS, 1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, 1.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new SleepGoal());
        this.hamsterGoToWheelGoal = new HamsterGoToWheelGoal();
        this.f_21345_.m_25352_(4, (Goal)this.hamsterGoToWheelGoal);
        this.f_21345_.m_25352_(4, (Goal)new SearchForItemsGoal(this, 1.25, FOOD_ITEMS, 8.0, 8.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new RunInWheelGoal());
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.3);
        } else {
            this.m_6858_(false);
        }
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 1.5);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (this.m_9236_().f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
            return !this.m_6898_(itemStack) || !(this.m_21223_() < this.m_21233_()) && this.m_21824_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player) && this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_()) {
                this.m_142075_(player, interactionHand, itemStack);
                this.m_5634_(2.0f);
                return InteractionResult.CONSUME;
            }
            if (this.m_21830_((LivingEntity)player)) {
                InteractionResult interactionResult = super.m_6071_(player, interactionHand);
                if (!interactionResult.m_19077_() || this.m_6162_()) {
                    this.m_21839_(!this.m_21827_());
                }
                if (this.m_21830_((LivingEntity)player) && player.m_6144_()) {
                    this.catchHamster(player);
                }
                return interactionResult;
            }
        } else if (this.m_6898_(itemStack)) {
            this.m_142075_(player, interactionHand, itemStack);
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, interactionHand);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return this.m_6162_() ? 0.2f : 0.3f;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public InteractionResult catchHamster(Player player) {
        ItemStack output = this.getCaughtItemStack();
        Hamster.saveDefaultDataToItemTag(this, output);
        if (!player.m_150109_().m_36054_(output)) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), output);
            itemEntity.m_32010_(0);
            itemEntity.m_20256_(itemEntity.m_20184_().m_82542_(0.0, 1.0, 0.0));
            this.m_9236_().m_7967_((Entity)itemEntity);
        }
        this.m_146870_();
        player.m_150109_().m_36054_(output);
        return InteractionResult.m_19078_((boolean)true);
    }

    private static void saveDefaultDataToItemTag(Hamster mob, ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (mob.m_8077_()) {
            itemStack.m_41714_(mob.m_7770_());
        }
        try {
            compoundTag.m_128376_("Air", (short)mob.m_20146_());
            compoundTag.m_128379_("Invulnerable", mob.m_20147_());
            if (mob.m_20151_()) {
                compoundTag.m_128379_("CustomNameVisible", mob.m_20151_());
            }
            if (mob.m_20067_()) {
                compoundTag.m_128379_("Silent", mob.m_20067_());
            }
            if (mob.m_20068_()) {
                compoundTag.m_128379_("NoGravity", mob.m_20068_());
            }
            if (mob.m_146886_()) {
                compoundTag.m_128379_("Glowing", true);
            }
            mob.m_7380_(compoundTag);
        }
        catch (Throwable var9) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)var9, (String)"Saving entity NBT");
            CrashReportCategory crashReportCategory = crashReport.m_127514_("Entity being saved");
            mob.m_7976_(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromHand();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public ItemStack getCaughtItemStack() {
        return new ItemStack((ItemLike)HamstersItems.HAMSTER.get());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)HamstersSoundEvents.HAMSTER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)HamstersSoundEvents.HAMSTER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)HamstersSoundEvents.HAMSTER_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 3.0f);
    }

    protected void playBegSound() {
        this.m_5496_((SoundEvent)HamstersSoundEvents.HAMSTER_BEG.get(), this.m_6121_(), this.m_6100_());
    }

    protected float m_6121_() {
        return 0.4f;
    }

    void clearStates() {
        this.setIsInterested(false);
        this.m_21837_(false);
        this.setSleeping(false);
    }

    public void setIsInterested(boolean bl) {
        this.f_19804_.m_135381_(DATA_INTERESTED, (Object)bl);
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INTERESTED);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EAT_COUNTER, (Object)0);
        this.f_19804_.m_135372_(DATA_INTERESTED, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)2);
        this.f_19804_.m_135372_(WAIT_TIME_BEFORE_RUN, (Object)0);
        this.f_19804_.m_135372_(WAIT_TIME_WHEN_RUNNING, (Object)0);
        this.f_19804_.m_135372_(FROM_HAND, (Object)false);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setVariant(Variant.BY_ID[compoundTag.m_128451_("Variant")]);
        this.setWaitTimeBeforeRunTicks(compoundTag.m_128451_("RunTicks"));
        this.setWaitTimeWhenRunningTicks(compoundTag.m_128451_("RunningTicks"));
        this.setFromHand(compoundTag.m_128471_("FromHand"));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant().getId());
        compoundTag.m_128405_("RunTicks", this.getWaitTimeBeforeRunTicks());
        compoundTag.m_128405_("RunningTicks", this.getWaitTimeWhenRunningTicks());
        compoundTag.m_128379_("FromHand", this.fromHand());
    }

    public int getWaitTimeBeforeRunTicks() {
        return (Integer)this.f_19804_.m_135370_(WAIT_TIME_BEFORE_RUN);
    }

    public void setWaitTimeBeforeRunTicks(int ticks) {
        this.f_19804_.m_135381_(WAIT_TIME_BEFORE_RUN, (Object)ticks);
    }

    public int getWaitTimeWhenRunningTicks() {
        return (Integer)this.f_19804_.m_135370_(WAIT_TIME_WHEN_RUNNING);
    }

    public void setWaitTimeWhenRunningTicks(int ticks) {
        this.f_19804_.m_135381_(WAIT_TIME_WHEN_RUNNING, (Object)ticks);
    }

    public boolean m_5803_() {
        return this.getFlag(32);
    }

    public void setSleeping(boolean bl) {
        this.setFlag(32, bl);
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)((Byte)this.f_19804_.m_135370_(f_21798_) | i)));
        } else {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)((Byte)this.f_19804_.m_135370_(f_21798_) & ~i)));
        }
    }

    private boolean getFlag(int i) {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & i) != 0;
    }

    void wakeUp() {
        this.setSleeping(false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21515_()) {
            if (this.m_20069_() || this.m_5448_() != null || this.m_9236_().m_46470_()) {
                this.wakeUp();
            }
            if (this.m_20069_() || this.m_5803_()) {
                this.m_21837_(false);
            }
        }
    }

    public void m_8107_() {
        List list;
        super.m_8107_();
        this.m_9236_();
        this.m_20183_();
        if (this.m_9236_().m_8055_(this.m_20183_()).m_60713_((Block)HamstersBlocks.HAMSTER_WHEEL.get())) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (this.getWaitTimeWhenRunningTicks() > 0) {
            this.setWaitTimeWhenRunningTicks(this.getWaitTimeWhenRunningTicks() - 1);
        }
        if (this.m_20159_() && this.m_20202_() instanceof SeatEntity && this.getWaitTimeWhenRunningTicks() == 0) {
            this.setWaitTimeBeforeRunTicks(this.f_19796_.m_188503_(400) + 1200);
            this.m_8127_();
            this.clearStates();
        }
        if (this.isInterested() && this.f_19797_ % 40 == 0) {
            this.playBegSound();
        }
        if (this.m_6084_() && !this.isInterested() && !this.m_5803_() && !this.m_6107_() && this.m_5448_() == null) {
            list = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82377_(8.0, 4.0, 8.0));
            for (Player player : list) {
                if (player.m_5833_() || !player.m_21093_((Predicate)FOOD_ITEMS) || !(this.m_20280_((Entity)player) < 2.0)) continue;
                this.setIsInterested(true);
                this.m_21573_().m_26573_();
            }
        }
        if (this.isInterested() && this.m_5448_() == null) {
            list = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82377_(8.0, 4.0, 8.0));
            for (Player player : list) {
                if (player.m_5833_() || !player.m_21093_((Predicate)FOOD_ITEMS) || !(this.m_20280_((Entity)player) > 2.0)) continue;
                this.setIsInterested(false);
            }
        }
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
    }

    public boolean m_7848_(Animal animal) {
        if (!this.m_21824_()) {
            return false;
        }
        if (!(animal instanceof Hamster)) {
            return false;
        }
        Hamster hamster = (Hamster)animal;
        return hamster.m_21824_() && super.m_7848_(animal);
    }

    public Variant getVariant() {
        return Variant.BY_ID[(Integer)this.f_19804_.m_135370_(DATA_VARIANT)];
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant.getId());
    }

    public boolean fromHand() {
        return (Boolean)this.f_19804_.m_135370_(FROM_HAND);
    }

    public void setFromHand(boolean fromHand) {
        this.f_19804_.m_135381_(FROM_HAND, (Object)fromHand);
    }

    @Nullable
    public Hamster getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        Hamster hamster = (Hamster)((EntityType)HamstersEntityType.HAMSTER.get()).m_20615_((Level)level);
        if (hamster != null && ageableMob instanceof Hamster) {
            Hamster hamster1 = (Hamster)ageableMob;
            if (this.f_19796_.m_188499_()) {
                hamster.setVariant(this.getVariant());
            } else {
                hamster.setVariant(hamster1.getVariant());
            }
            if (this.m_21824_()) {
                hamster.m_21816_(this.m_21805_());
                hamster.m_7105_(true);
            }
        }
        return hamster;
    }

    public boolean m_7066_(ItemStack pItemstack) {
        EquipmentSlot slot = Hamster.m_147233_((ItemStack)pItemstack);
        if (!this.m_6844_(slot).m_41619_()) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND && super.m_7066_(pItemstack);
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        ItemStack stack = pItemEntity.m_32055_();
        if (!this.m_5803_() && this.m_21205_().m_41619_() && FOOD_ITEMS.test(stack)) {
            this.m_21053_(pItemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, stack);
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)pItemEntity, stack.m_41613_());
            pItemEntity.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.m_21205_().m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, this.m_21205_());
            itemEntity.m_32010_(40);
            itemEntity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_213945_(this.f_19796_, pDifficulty);
        if (pSpawnData == null) {
            RandomSource randomSource = pLevel.m_213780_();
            this.setVariant(Variant.values()[randomSource.m_188503_(Variant.values().length)]);
        }
        return pSpawnData;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance pDifficulty) {
        if (random.m_188501_() < 0.2f) {
            float chance = random.m_188501_();
            ItemStack stack = chance < 0.1f ? new ItemStack((ItemLike)Items.f_42733_) : (chance < 0.15f ? new ItemStack((ItemLike)Items.f_42577_) : (chance < 0.3f ? new ItemStack((ItemLike)Items.f_42578_) : new ItemStack((ItemLike)Items.f_42404_)));
            this.m_8061_(EquipmentSlot.MAINHAND, stack);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animController)});
    }

    protected <E extends Hamster> PlayState animController(AnimationState<E> event) {
        if (this.m_5803_()) {
            event.setAnimation(SLEEP);
        } else if (this.isInterested() || this.m_21825_()) {
            event.setAnimation(STANDING);
        } else if (event.isMoving()) {
            if (this.m_20142_()) {
                event.setControllerSpeed(1.3f);
                event.setAnimation(RUN);
            } else {
                event.setControllerSpeed(1.1f);
                event.setAnimation(WALK);
            }
        } else if (this.m_20159_() && this.m_20202_() instanceof SeatEntity) {
            event.setControllerSpeed(1.4f);
            event.setAnimation(WALK);
        } else {
            event.setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    static /* synthetic */ RandomSource access$300(Hamster x0) {
        return x0.f_19796_;
    }

    public class HamsterLookControl
    extends LookControl {
        public HamsterLookControl() {
            super((Mob)Hamster.this);
        }

        public void m_8128_() {
            if (!(Hamster.this.m_20202_() instanceof SeatEntity)) {
                super.m_8128_();
            } else {
                BlockState state = Hamster.this.m_9236_().m_8055_(Hamster.this.m_20183_());
                if (state.m_60713_((Block)HamstersBlocks.HAMSTER_WHEEL.get())) {
                    BlockPos pos1 = state.m_61143_((Property)HamsterWheelBlock.FACING) == Direction.SOUTH ? Hamster.this.m_20183_().m_122030_(1) : (state.m_61143_((Property)HamsterWheelBlock.FACING) == Direction.NORTH ? Hamster.this.m_20183_().m_122025_(1) : (state.m_61143_((Property)HamsterWheelBlock.FACING) == Direction.EAST ? Hamster.this.m_20183_().m_122013_(1) : Hamster.this.m_20183_().m_122020_(1)));
                    Hamster.this.setSleeping(false);
                    Hamster.this.m_21837_(false);
                    Hamster.this.m_7618_(EntityAnchorArgument.Anchor.FEET, new Vec3((double)((float)pos1.m_123341_() + 0.5f), (double)((float)pos1.m_123342_() + 0.5f), (double)((float)pos1.m_123343_() + 0.5f)));
                }
            }
        }

        protected boolean m_8106_() {
            return !(Hamster.this.m_20202_() instanceof SeatEntity);
        }
    }

    private class SleepGoal
    extends Goal {
        private final TargetingConditions alertableTargeting = TargetingConditions.m_148353_().m_26883_(6.0).m_148355_().m_26888_((Predicate)new HamsterAlertableEntitiesSelector());
        private final int WAIT_TIME_BEFORE_SLEEP = Hamster.access$300(Hamster.this).m_188503_(100) + 100;
        private int countdown;

        public SleepGoal() {
            this.countdown = Hamster.this.f_19796_.m_188503_(this.WAIT_TIME_BEFORE_SLEEP);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (Hamster.this.f_20900_ == 0.0f && Hamster.this.f_20901_ == 0.0f && Hamster.this.f_20902_ == 0.0f) {
                return this.canSleep() || Hamster.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return (Hamster.this.m_9236_().m_46468_() >= 1000L && Hamster.this.m_9236_().m_46468_() <= 10000L || Hamster.this.m_9236_().m_46468_() >= 16000L && Hamster.this.m_9236_().m_46468_() <= 21000L) && !Hamster.this.f_146808_ && !this.alertable() && !Hamster.this.m_20159_();
        }

        public void m_8041_() {
            this.countdown = Hamster.this.f_19796_.m_188503_(this.WAIT_TIME_BEFORE_SLEEP);
            Hamster.this.clearStates();
        }

        public void m_8056_() {
            Hamster.this.m_21837_(false);
            Hamster.this.setIsInterested(false);
            Hamster.this.m_6862_(false);
            Hamster.this.setSleeping(true);
            Hamster.this.m_21573_().m_26573_();
            Hamster.this.m_21566_().m_6849_(Hamster.this.m_20185_(), Hamster.this.m_20186_(), Hamster.this.m_20189_(), 0.0);
        }

        protected boolean alertable() {
            return !Hamster.this.m_9236_().m_45971_(LivingEntity.class, this.alertableTargeting, (LivingEntity)Hamster.this, Hamster.this.m_20191_().m_82377_(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    class HamsterGoToWheelGoal
    extends Goal {
        private final Predicate<BlockState> VALID_GATHERING_BLOCKS = blockState -> {
            if (blockState.m_60713_((Block)HamstersBlocks.HAMSTER_WHEEL.get())) {
                return !blockState.m_61138_((Property)BlockStateProperties.f_61362_) || (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) == false;
            }
            return false;
        };
        @Nullable
        private Vec3 wheelPos;

        HamsterGoToWheelGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Optional<BlockPos> optional = this.findNearbyResource();
            if (optional.isPresent() && !HamsterWheelBlock.isOccupied(Hamster.this.m_9236_(), optional.get()) && Hamster.this.getWaitTimeBeforeRunTicks() == 0) {
                Hamster.this.f_21344_.m_26519_((double)optional.get().m_123341_() + 0.5, (double)optional.get().m_123342_(), (double)optional.get().m_123343_() + 0.5, (double)1.2f);
                return !Hamster.this.m_9236_().m_46471_() && !Hamster.this.m_5803_() && !Hamster.this.m_21825_();
            }
            return false;
        }

        public boolean m_8045_() {
            Optional<BlockPos> optional = this.findNearbyResource();
            if (optional.isPresent() && !HamsterWheelBlock.isOccupied(Hamster.this.m_9236_(), optional.get()) && Hamster.this.getWaitTimeBeforeRunTicks() == 0) {
                return !Hamster.this.m_9236_().m_46471_() && !Hamster.this.m_5803_() && !Hamster.this.m_21825_();
            }
            return false;
        }

        public void m_8041_() {
            Hamster.this.f_21344_.m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            Optional<BlockPos> optional = this.findNearbyResource();
            if (HamsterWheelBlock.isOccupied(Hamster.this.m_9236_(), optional.get())) {
                this.m_8041_();
            }
            if (!HamsterWheelBlock.isOccupied(Hamster.this.m_9236_(), optional.get()) && Hamster.this.getWaitTimeBeforeRunTicks() == 0) {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)((Vec3i)optional.get()));
                if (vec3.m_82554_(Hamster.this.m_20182_()) > 1.4) {
                    this.wheelPos = vec3;
                    this.setWantedPos();
                    return;
                }
                if (this.wheelPos == null) {
                    this.wheelPos = vec3;
                }
                if (Hamster.this.m_20182_().m_82554_(this.wheelPos) <= 1.4) {
                    Hamster.this.setWaitTimeWhenRunningTicks(Hamster.this.f_19796_.m_188503_(300) + 100);
                    HamsterWheelBlock.sitDown(Hamster.this.m_9236_(), optional.get(), (Entity)Hamster.this);
                    this.m_8041_();
                }
            }
        }

        private void setWantedPos() {
            Hamster.this.m_21566_().m_6849_(this.wheelPos.m_7096_(), this.wheelPos.m_7098_(), this.wheelPos.m_7094_(), (double)0.7f);
        }

        private Optional<BlockPos> findNearbyResource() {
            return this.findNearestBlock(this.VALID_GATHERING_BLOCKS);
        }

        private Optional<BlockPos> findNearestBlock(Predicate<BlockState> predicate) {
            BlockPos blockPos = Hamster.this.m_20183_();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i <= 5.0) {
                int j = 0;
                while ((double)j < 5.0) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutableBlockPos.m_122154_((Vec3i)blockPos, k, i - 1, l);
                            if (blockPos.m_123314_((Vec3i)mutableBlockPos, 5.0) && predicate.test(Hamster.this.m_9236_().m_8055_((BlockPos)mutableBlockPos))) {
                                return Optional.of(mutableBlockPos);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    private class RunInWheelGoal
    extends Goal {
        public RunInWheelGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return !Hamster.this.m_5803_() && !Hamster.this.f_146808_ && Hamster.this.m_20159_() && Hamster.this.m_20202_() instanceof SeatEntity;
        }

        public boolean m_8045_() {
            return Hamster.this.m_20159_() && Hamster.this.m_20202_() instanceof SeatEntity;
        }
    }

    public static enum Variant {
        WHITE(0, "white"),
        PEACHES_AND_CREAM(1, "peaches_and_cream"),
        ORANGE(2, "orange"),
        GREY_WHITE(3, "grey_white"),
        BROWN(4, "brown"),
        BLACK_WHITE(5, "black_white"),
        BLACK(6, "black");

        public static final Variant[] BY_ID;
        private final int id;
        private final String name;

        private Variant(int j, String string2) {
            this.id = j;
            this.name = string2;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Variant getTypeById(int id) {
            for (Variant type : Variant.values()) {
                if (type.id != id) continue;
                return type;
            }
            return ORANGE;
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }

    public static class HamsterAlertableEntitiesSelector
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity livingEntity) {
            if (livingEntity instanceof Hamster) {
                return false;
            }
            if (livingEntity instanceof Player && (livingEntity.m_5833_() || ((Player)livingEntity).m_7500_())) {
                return false;
            }
            return !livingEntity.m_5803_() && !livingEntity.m_20163_();
        }
    }
}

