/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LightningBoltRenderer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LightningBolt;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RainbowLightingRenderer
extends LightningBoltRenderer {
    public RainbowLightingRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void m_7392_(LightningBolt lightning, float partialTick, float p_115268_, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float[] offsetsX = new float[16];
        float[] offsetsZ = new float[16];
        float currentX = 0.0f;
        float currentZ = 0.0f;
        RandomSource randomSource = RandomSource.m_216335_((long)lightning.f_20859_);
        for (int i = 7; i >= 0; --i) {
            offsetsX[i] = currentX;
            offsetsZ[i] = currentZ;
            currentX += (float)(randomSource.m_188503_(15) - 7);
            currentZ += (float)(randomSource.m_188503_(15) - 7);
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110502_());
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float gameTime = (float)(System.currentTimeMillis() % 20000L) / 1000.0f;
        float colorWave = (float)Math.sin((double)gameTime * 2.0) * 0.5f + 0.5f;
        float pulseTime = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
        float sparkleTime = (float)(System.currentTimeMillis() % 1500L) / 1500.0f;
        this.renderLightningLayer(lightning, offsetsX, offsetsZ, currentX, currentZ, matrix, vertexConsumer, gameTime, colorWave, pulseTime, sparkleTime, 1.0f, false);
        this.renderLightningLayer(lightning, offsetsX, offsetsZ, currentX, currentZ, matrix, vertexConsumer, gameTime + 0.3f, colorWave, pulseTime, sparkleTime, 0.6f, true);
        this.renderLightningLayer(lightning, offsetsX, offsetsZ, currentX, currentZ, matrix, vertexConsumer, gameTime + 0.6f, colorWave, pulseTime, sparkleTime, 0.3f, true);
    }

    private void renderLightningLayer(LightningBolt lightning, float[] offsetsX, float[] offsetsZ, float currentX, float currentZ, Matrix4f matrix, VertexConsumer vertexConsumer, float timeOffset, float colorWave, float pulseTime, float sparkleTime, float layerAlpha, boolean isInnerLayer) {
        for (int branch = 0; branch < 4; ++branch) {
            RandomSource branchRandom = RandomSource.m_216335_((long)(lightning.f_20859_ + (long)branch));
            for (int segment = 0; segment < 3; ++segment) {
                int startPoint = 7;
                int endPoint = 0;
                if (segment > 0) {
                    startPoint = 7 - segment;
                }
                if (segment > 0) {
                    endPoint = startPoint - 2;
                }
                float segmentX = offsetsX[startPoint] - currentX;
                float segmentZ = offsetsZ[startPoint] - currentZ;
                for (int point = startPoint; point >= endPoint; --point) {
                    float nextX = segmentX;
                    float nextZ = segmentZ;
                    if (segment == 0) {
                        segmentX += (float)(branchRandom.m_188503_(11) - 5);
                        segmentZ += (float)(branchRandom.m_188503_(11) - 5);
                    } else {
                        segmentX += (float)(branchRandom.m_188503_(31) - 15);
                        segmentZ += (float)(branchRandom.m_188503_(31) - 15);
                    }
                    float thickness1 = this.calculateThickness(branch, point, segment, pulseTime, isInnerLayer);
                    float thickness2 = this.calculateThickness(branch, point, segment, pulseTime, isInnerLayer);
                    float baseAlpha = 1.0f - (float)point / 7.0f;
                    float pulseAlpha = (float)(Math.sin((double)pulseTime * Math.PI * 2.0 + (double)point * 0.5) * 0.3 + 0.7);
                    float finalAlpha = baseAlpha * 0.9f * layerAlpha * pulseAlpha;
                    RainbowLightingRenderer.renderQuad(matrix, vertexConsumer, segmentX, segmentZ, point, nextX, nextZ, thickness1, thickness2, false, false, true, false, finalAlpha, timeOffset, colorWave, sparkleTime, isInnerLayer);
                    RainbowLightingRenderer.renderQuad(matrix, vertexConsumer, segmentX, segmentZ, point, nextX, nextZ, thickness1, thickness2, true, false, true, true, finalAlpha, timeOffset, colorWave, sparkleTime, isInnerLayer);
                    RainbowLightingRenderer.renderQuad(matrix, vertexConsumer, segmentX, segmentZ, point, nextX, nextZ, thickness1, thickness2, true, true, false, true, finalAlpha, timeOffset, colorWave, sparkleTime, isInnerLayer);
                    RainbowLightingRenderer.renderQuad(matrix, vertexConsumer, segmentX, segmentZ, point, nextX, nextZ, thickness1, thickness2, false, true, false, false, finalAlpha, timeOffset, colorWave, sparkleTime, isInnerLayer);
                }
            }
        }
    }

    private float calculateThickness(int branch, int point, int segment, float pulseTime, boolean isInnerLayer) {
        float baseThickness = 0.1f + (float)branch * 0.2f;
        if (segment == 0) {
            baseThickness *= (float)point * 0.1f + 1.0f;
        }
        float pulse = (float)(Math.sin((double)pulseTime * Math.PI * 3.0 + (double)point * 0.8) * 0.4 + 1.0);
        if (isInnerLayer) {
            baseThickness *= 0.7f;
        }
        return baseThickness * pulse;
    }

    private static void renderQuad(Matrix4f matrix, VertexConsumer vertexConsumer, float x1, float z1, int segmentIndex, float x2, float z2, float thickness1, float thickness2, boolean flag1, boolean flag2, boolean flag3, boolean flag4, float alpha, float timeOffset, float colorWave, float sparkleTime, boolean isInnerLayer) {
        float baseHue1 = ((float)segmentIndex / 2.5f + timeOffset) % 1.0f;
        float baseHue2 = ((float)(segmentIndex + 1) / 2.5f + timeOffset) % 1.0f;
        float hue1 = (baseHue1 + colorWave * 0.3f) % 1.0f;
        float hue2 = (baseHue2 + colorWave * 0.3f) % 1.0f;
        float saturation = 0.9f + colorWave * 0.1f;
        float brightness = isInnerLayer ? 1.0f : 0.7f + colorWave * 0.3f;
        float sparkleBoost = (float)(Math.sin((double)sparkleTime * Math.PI * 4.0 + (double)segmentIndex) * 0.2 + 1.0);
        int rgb1 = Color.HSBtoRGB(hue1, saturation, Math.min(brightness *= sparkleBoost, 1.0f));
        int rgb2 = Color.HSBtoRGB(hue2, saturation, Math.min(brightness, 1.0f));
        float r1 = (float)(rgb1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(rgb1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(rgb1 & 0xFF) / 255.0f;
        float r2 = (float)(rgb2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(rgb2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(rgb2 & 0xFF) / 255.0f;
        vertexConsumer.m_252986_(matrix, x1 + (flag1 ? thickness2 : -thickness2), (float)(segmentIndex * 16), z1 + (flag2 ? thickness2 : -thickness2)).m_85950_(r1, g1, b1, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, x2 + (flag1 ? thickness1 : -thickness1), (float)((segmentIndex + 1) * 16), z2 + (flag2 ? thickness1 : -thickness1)).m_85950_(r2, g2, b2, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, x2 + (flag3 ? thickness1 : -thickness1), (float)((segmentIndex + 1) * 16), z2 + (flag4 ? thickness1 : -thickness1)).m_85950_(r2, g2, b2, alpha).m_5752_();
        vertexConsumer.m_252986_(matrix, x1 + (flag3 ? thickness2 : -thickness2), (float)(segmentIndex * 16), z1 + (flag4 ? thickness2 : -thickness2)).m_85950_(r1, g1, b1, alpha).m_5752_();
    }
}

