/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.event;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.wzz.time_slow.damagetype.ArmorPiercingDamage;
import net.wzz.time_slow.init.ModEnchantments;
import net.wzz.time_slow.util.TaczGunHandler;
import net.wzz.time_slow.util.Utils;

@Mod.EventBusSubscriber
public class ArmorPiercingHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!(event.getSource() instanceof ArmorPiercingDamage)) {
                ItemStack weapon = player.m_21205_();
                if (!TaczGunHandler.isGun(weapon)) {
                    return;
                }
                int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.ARMOR_PIERCING.get()), (ItemStack)weapon);
                if (level > 0) {
                    LivingEntity target = event.getEntity();
                    float originalDamage = event.getAmount();
                    float armorPiercingFactor = (float)level * 0.1f;
                    float armorValue = target.m_21230_();
                    float effectiveArmor = armorValue * (1.0f - armorPiercingFactor);
                    float damageMultiplier = 1.0f - Math.min(20.0f, Math.max(effectiveArmor / 5.0f, effectiveArmor - originalDamage / 2.0f)) / 25.0f;
                    float finalDamage = originalDamage * damageMultiplier;
                    event.setCanceled(true);
                    Utils.notHurtTime(target);
                    target.m_6469_(ArmorPiercingDamage.attack((Entity)player), finalDamage * 1.1f);
                }
            }
        }
    }
}

