/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.event;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.multiplayer.ClientLevel;

public class ClientTimeInterpolator {
    private static final Map<ClientLevel, Float> timeMultipliers = new ConcurrentHashMap<ClientLevel, Float>();
    private static final Map<ClientLevel, Long> baseTime = new ConcurrentHashMap<ClientLevel, Long>();
    private static final Map<ClientLevel, Long> lastRealTime = new ConcurrentHashMap<ClientLevel, Long>();
    private static final ThreadLocal<Boolean> isIntercepting = ThreadLocal.withInitial(() -> false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTimeMultiplier(ClientLevel level, float multiplier) {
        if (level == null) {
            return;
        }
        Float oldMultiplier = timeMultipliers.get(level);
        long currentSystemTime = System.currentTimeMillis();
        if (oldMultiplier == null) {
            long realServerTime;
            baseTime.put(level, currentSystemTime);
            isIntercepting.set(true);
            try {
                if (level.m_6106_() instanceof ClientLevel.ClientLevelData) {
                    ClientLevel.ClientLevelData levelData = level.m_6106_();
                    realServerTime = levelData.f_104838_;
                } else {
                    realServerTime = level.m_46468_();
                }
            }
            finally {
                isIntercepting.set(false);
            }
            lastRealTime.put(level, realServerTime);
        } else {
            Long oldBaseTime = baseTime.get(level);
            Long oldRealTime = lastRealTime.get(level);
            if (oldBaseTime != null && oldRealTime != null) {
                long elapsedMs = currentSystemTime - oldBaseTime;
                long elapsedTicks = elapsedMs / 50L;
                long acceleratedTicks = (long)((float)elapsedTicks * oldMultiplier.floatValue());
                long currentCorrectTime = oldRealTime + acceleratedTicks;
                baseTime.put(level, currentSystemTime);
                lastRealTime.put(level, currentCorrectTime);
            }
        }
        timeMultipliers.put(level, Float.valueOf(multiplier));
    }

    private static long getRealDayTime(ClientLevel level) {
        if (level.m_6106_() instanceof ClientLevel.ClientLevelData) {
            ClientLevel.ClientLevelData levelData = level.m_6106_();
            return levelData.f_104838_;
        }
        isIntercepting.set(true);
        try {
            long l = level.m_6106_().m_6792_();
            return l;
        }
        finally {
            isIntercepting.set(false);
        }
    }

    public static boolean isCurrentlyIntercepting() {
        return isIntercepting.get();
    }

    public static long getInterpolatedDayTime(ClientLevel level) {
        float multiplier = timeMultipliers.getOrDefault(level, Float.valueOf(1.0f)).floatValue();
        if (Math.abs(multiplier - 1.0f) < 0.01f) {
            return ClientTimeInterpolator.getRealDayTime(level);
        }
        Long startTime = baseTime.get(level);
        Long serverStartTime = lastRealTime.get(level);
        if (startTime == null || serverStartTime == null) {
            return ClientTimeInterpolator.getRealDayTime(level);
        }
        long currentRealTime = System.currentTimeMillis();
        long elapsedMs = currentRealTime - startTime;
        long elapsedTicks = elapsedMs / 50L;
        long acceleratedTicks = (long)((float)elapsedTicks * multiplier);
        return serverStartTime + acceleratedTicks;
    }

    public static float getInterpolatedTimeOfDay(ClientLevel level, float partialTick) {
        long interpolatedDayTime = ClientTimeInterpolator.getInterpolatedDayTime(level);
        float timeOfDay = (float)(interpolatedDayTime % 24000L) / 24000.0f;
        float adjustedPartialTick = partialTick / 1000.0f;
        timeOfDay += adjustedPartialTick / 24000.0f;
        while (timeOfDay >= 1.0f) {
            timeOfDay -= 1.0f;
        }
        while (timeOfDay < 0.0f) {
            timeOfDay += 1.0f;
        }
        return timeOfDay;
    }

    public static float getInterpolatedSunAngle(ClientLevel level, float partialTick) {
        float timeOfDay = ClientTimeInterpolator.getInterpolatedTimeOfDay(level, partialTick);
        return (timeOfDay - 0.25f) * 2.0f * (float)Math.PI;
    }

    public static float getTimeMultiplier(ClientLevel level) {
        return timeMultipliers.getOrDefault(level, Float.valueOf(1.0f)).floatValue();
    }

    public static void cleanupLevel(ClientLevel level) {
        timeMultipliers.remove(level);
        baseTime.remove(level);
        lastRealTime.remove(level);
    }
}

