/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.event;

import java.util.Random;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.wzz.time_slow.event.TimeAccelerationCore;
import net.wzz.time_slow.init.ModItems;
import net.wzz.time_slow.network.Cause;
import net.wzz.time_slow.util.CuriosUtil;
import net.wzz.time_slow.util.Utils;

@Mod.EventBusSubscriber
public class EventHandle {
    @SubscribeEvent
    public static void onHurtEvent(LivingHurtEvent e) {
        ServerPlayer serverPlayer;
        ItemStack[] itemStackArray;
        if (e.getSource() != null && (itemStackArray = e.getSource().m_7639_()) instanceof Player) {
            Player player = (Player)itemStackArray;
            if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.time_slow.get()) && Utils.timeSlow) {
                e.setAmount(e.getAmount() * 1.5f);
            }
            if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.power_defence.get())) {
                e.setAmount(e.getAmount() * 1.3f);
            }
            if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get()) && player.getPersistentData().m_128471_("isStrDamage")) {
                e.setAmount(e.getAmount() * 99.9f);
                Utils.notHurtTime(e.getEntity());
                e.getEntity().m_6469_(e.getEntity().m_269291_().m_269341_(), player.m_21233_() * 5.0f);
            }
            if (player.getPersistentData().m_128471_("isKnightDDDD")) {
                Utils.resetHurtTime((LivingEntity)player, 40);
                int i = new Random().nextInt(101);
                if (i <= 20) {
                    e.setCanceled(true);
                    Utils.playSound((LevelAccessor)player.f_19853_, SoundEvents.f_12346_, (Entity)player);
                }
            }
            if (player.getPersistentData().m_128471_("noDamageUsePower")) {
                e.setAmount(e.getAmount() * 2.3f);
                player.m_5634_(e.getAmount());
                player.getPersistentData().m_128379_("hasDamagePower", true);
                int i = new Random().nextInt(101);
                if (i <= 15) {
                    e.getEntity().f_20916_ = 0;
                    Utils.forceSetHealth(e.getEntity(), e.getEntity().m_21223_() - e.getAmount() * 3.0f);
                }
            }
            if (player.getPersistentData().m_128471_("DamageUseHeal")) {
                if (!player.m_6144_()) {
                    e.getEntity().m_5634_(e.getEntity().m_21233_());
                    player.m_5634_(player.m_21233_());
                    Utils.spawnParticles((Entity)e.getEntity(), ParticleTypes.f_123750_, 15, 0.1f);
                    itemStackArray = Utils.getPlayerArmorStacks(player);
                    int n = itemStackArray.length;
                    for (int i = 0; i < n; ++i) {
                        ItemStack itemStack = itemStackArray[i];
                        if (itemStack.m_41619_()) continue;
                        itemStack.m_41721_(0);
                    }
                    if (!player.m_21205_().m_41619_()) {
                        player.m_21205_().m_41721_(0);
                    }
                    Utils.playSound((LevelAccessor)player.f_19853_, SoundEvents.f_12275_, (Entity)player);
                } else if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get()) && !(e.getEntity() instanceof Player)) {
                    Utils.reduceMaxHealth(e.getEntity());
                }
                player.getPersistentData().m_128379_("DamageUseHeal", false);
            }
        }
        if (e.getEntity().getPersistentData().m_128471_("noDamageUsePower")) {
            e.setAmount(e.getAmount() * 0.5f);
            e.getEntity().getPersistentData().m_128379_("hasDamagePower", true);
        }
        if (CuriosUtil.hasCurios(e.getEntity(), (Item)ModItems.god_defence.get()) && Utils.isNether(e.getEntity().f_19853_)) {
            e.setAmount(e.getAmount() * 0.5f);
        }
        if ((itemStackArray = e.getEntity()) instanceof ServerPlayer && TimeAccelerationCore.getSpeedMultiplier((serverPlayer = (ServerPlayer)itemStackArray).m_284548_()) > 1.0f && CuriosUtil.hasCurios((LivingEntity)serverPlayer, (Item)ModItems.time_slow.get())) {
            Utils.resetHurtTime((LivingEntity)serverPlayer, 30);
        }
        if (e.getEntity().getPersistentData().m_128471_("notDamageGod") && !Utils.isNether(e.getEntity().f_19853_)) {
            e.setAmount(e.getAmount() * 0.5f);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent e) {
        if (e.getEntity().getPersistentData().m_128471_("noDamageUseCause") && e.getAmount() >= e.getEntity().m_21223_()) {
            for (Entity b : Utils.findAllEntitiesWithSource((Entity)e.getEntity(), 32.0)) {
                if (!(b instanceof LivingEntity) || !b.getPersistentData().m_128471_("MyZBBB")) continue;
                b.m_6034_(b.getPersistentData().m_128459_("MyXB"), b.getPersistentData().m_128459_("MyYB"), b.getPersistentData().m_128459_("MyZB"));
                ((LivingEntity)b).m_21153_(b.getPersistentData().m_128457_("MyZBH"));
                b.getPersistentData().m_128473_("MyZBBB");
            }
            e.getEntity().getPersistentData().m_128379_("noDamageUseCause", false);
            Cause.rewindManager.rewind();
            Utils.playSound((LevelAccessor)e.getEntity().f_19853_, "rtz", (Entity)e.getEntity());
            e.setCanceled(true);
        }
        if (e.getEntity().getPersistentData().m_128471_("notDamageGod") && Utils.isNether(e.getEntity().f_19853_)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent e) {
        if (CuriosUtil.hasCurios(e.getEntity(), (Item)ModItems.god_defence.get())) {
            e.setDamageMultiplier(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHurtEvent e) {
        if (CuriosUtil.hasCurios(e.getEntity(), (Item)ModItems.god_defence.get())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        e.getEntity().getPersistentData().m_128379_("noUse", false);
        e.getEntity().getPersistentData().m_128379_("noUse222", false);
        e.getEntity().getPersistentData().m_128379_("noUse333", false);
        e.getEntity().getPersistentData().m_128379_("noUseKing", false);
        e.getEntity().getPersistentData().m_128379_("noUseKnight", false);
        e.getEntity().getPersistentData().m_128379_("noUseCause", false);
        e.getEntity().getPersistentData().m_128379_("noDamageUseCause", false);
        e.getEntity().getPersistentData().m_128379_("noDamageUsePower", false);
        e.getEntity().getPersistentData().m_128379_("noUsePower", false);
        e.getEntity().getPersistentData().m_128379_("DamageUseHeal", false);
        e.getEntity().getPersistentData().m_128379_("notDamageGod", false);
        e.getEntity().getPersistentData().m_128379_("noUseGod", false);
        e.getEntity().getPersistentData().m_128379_("DamageUseHeal2", false);
    }
}

