/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.event;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.wzz.time_slow.init.ModItems;
import net.wzz.time_slow.util.CuriosUtil;

@Mod.EventBusSubscriber(modid="time_slow", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SaviorGuardianEventHandler {
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
            event.setAmount(event.getAmount() * 0.05f);
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPotionApplicable(MobEffectEvent.Applicable event) {
        MobEffect effect;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get()) && !(effect = event.getEffectInstance().m_19544_()).m_19486_()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
            long lastUse;
            long invulnerableUntil;
            int i;
            if (event.getAmount() <= player.m_21233_() * 0.2f) {
                event.setCanceled(true);
            }
            if ((i = new Random().nextInt(101)) <= 30) {
                event.setCanceled(true);
            }
            CompoundTag playerTag = player.getPersistentData();
            long currentTime = player.m_9236_().m_46467_();
            if (currentTime < (invulnerableUntil = playerTag.m_128454_("SaviorInvulnerable"))) {
                event.setCanceled(true);
                return;
            }
            float damage = event.getAmount() * 0.1f;
            if ((player.m_21223_() - damage <= 0.0f || player.m_21223_() <= player.m_21233_() * 0.1f) && currentTime - (lastUse = playerTag.m_128454_("LastFatalProtection")) >= 1200L) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get()) && event.getAmount() >= player.m_21223_() * 0.25f) {
            event.setAmount(player.m_21223_() * 0.25f);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
            event.setNewSpeed(event.getOriginalSpeed() * 20.0f);
        }
    }

    @SubscribeEvent
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        Player player = event.getEntity();
        if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        CompoundTag data = player.getPersistentData();
        if (CuriosUtil.hasCurios((LivingEntity)player, (Item)ModItems.SAVIOR_GUARDIAN_ITEM.get())) {
            long invulnerableUntil;
            long currentTime;
            if (!player.m_150110_().f_35936_ && !player.m_5833_()) {
                player.m_150110_().f_35936_ = true;
                player.m_6885_();
            }
            if ((currentTime = player.m_9236_().m_46467_()) < (invulnerableUntil = data.m_128454_("SaviorInvulnerable")) && currentTime % 4L == 0L) {
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123767_, player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 2.0, player.m_20186_() + player.m_217043_().m_188500_() * 2.0, player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 2.0, 0.0, 0.1, 0.0);
            }
        }
    }

    public static class PlayerLightningData {
        public static final String PRESSING_KEY = "LightningPressing";
        public static final String TARGET_POS_KEY = "LightningTargetPos";
        public static final String START_TICK_KEY = "LightningStartTick";
        public static final String TARGET_ENTITY_ID_KEY = "LightningTargetEntityId";
    }
}

