/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.wzz.time_slow.event.ClientTimeInterpolator;
import net.wzz.time_slow.event.TimeAccelerationCore;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class MixinTimeSpeed {

    @Mixin(value={ClientLevel.ClientLevelData.class})
    public static class ClientLevelDataTimeMixin {
        @Unique
        private ClientLevel time_slow$getCurrentLevel() {
            Minecraft minecraft = Minecraft.m_91087_();
            return minecraft.f_91073_;
        }

        @Inject(method={"getGameTime"}, at={@At(value="HEAD")}, cancellable=true)
        private void interceptGameTime(CallbackInfoReturnable<Long> cir) {
            if (ClientTimeInterpolator.isCurrentlyIntercepting()) {
                return;
            }
            ClientLevel level = this.time_slow$getCurrentLevel();
            if (level == null) {
                return;
            }
            float multiplier = ClientTimeInterpolator.getTimeMultiplier(level);
            if (Math.abs(multiplier - 1.0f) > 0.01f) {
                long interpolatedTime = ClientTimeInterpolator.getInterpolatedDayTime(level);
                cir.setReturnValue((Object)interpolatedTime);
            }
        }

        @Inject(method={"getDayTime"}, at={@At(value="HEAD")}, cancellable=true)
        private void interceptDayTime(CallbackInfoReturnable<Long> cir) {
            if (ClientTimeInterpolator.isCurrentlyIntercepting()) {
                return;
            }
            ClientLevel level = this.time_slow$getCurrentLevel();
            if (level == null) {
                return;
            }
            float multiplier = ClientTimeInterpolator.getTimeMultiplier(level);
            if (Math.abs(multiplier - 1.0f) > 0.01f) {
                long interpolatedTime = ClientTimeInterpolator.getInterpolatedDayTime(level);
                cir.setReturnValue((Object)interpolatedTime);
            }
        }
    }

    @Mixin(value={SaplingBlock.class})
    public static abstract class SaplingAccelerationMixin {
        @Shadow
        public abstract void m_222000_(ServerLevel var1, BlockPos var2, BlockState var3, RandomSource var4);

        @Inject(method={"randomTick"}, at={@At(value="HEAD")})
        private void accelerateSaplingGrowth(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
            float multiplier = TimeAccelerationCore.getSpeedMultiplier(level);
            if (multiplier > 1.0f) {
                int extraTicks = (int)(multiplier - 1.0f);
                for (int i = 0; i < extraTicks; ++i) {
                    if (!(random.m_188501_() < 0.2f)) continue;
                    this.myRandomTick(state, level, pos, random);
                }
            }
        }

        @Unique
        public void myRandomTick(BlockState p_222011_, ServerLevel p_222012_, BlockPos p_222013_, RandomSource p_222014_) {
            if (p_222012_.isAreaLoaded(p_222013_, 1) && p_222012_.m_46803_(p_222013_.m_7494_()) >= 9 && p_222014_.m_188503_(7) == 0) {
                this.m_222000_(p_222012_, p_222013_, p_222011_, p_222014_);
            }
        }
    }

    @Mixin(value={Level.class})
    public static class LevelMixin {
        @Unique
        private ClientLevel time_slow$getCurrentLevel() {
            Minecraft minecraft = Minecraft.m_91087_();
            return minecraft.f_91073_;
        }

        @Inject(method={"getGameTime"}, at={@At(value="HEAD")}, cancellable=true)
        private void interceptGameTime(CallbackInfoReturnable<Long> cir) {
            if (ClientTimeInterpolator.isCurrentlyIntercepting()) {
                return;
            }
            ClientLevel level = this.time_slow$getCurrentLevel();
            if (level == null) {
                return;
            }
            float multiplier = ClientTimeInterpolator.getTimeMultiplier(level);
            if (Math.abs(multiplier - 1.0f) > 0.01f) {
                long interpolatedTime = ClientTimeInterpolator.getInterpolatedDayTime(level);
                cir.setReturnValue((Object)interpolatedTime);
            }
        }

        @Inject(method={"getDayTime"}, at={@At(value="HEAD")}, cancellable=true)
        private void interceptDayTime(CallbackInfoReturnable<Long> cir) {
            if (ClientTimeInterpolator.isCurrentlyIntercepting()) {
                return;
            }
            ClientLevel level = this.time_slow$getCurrentLevel();
            if (level == null) {
                return;
            }
            float multiplier = ClientTimeInterpolator.getTimeMultiplier(level);
            if (Math.abs(multiplier - 1.0f) > 0.01f) {
                long interpolatedTime = ClientTimeInterpolator.getInterpolatedDayTime(level);
                cir.setReturnValue((Object)interpolatedTime);
            }
        }

        @Inject(method={"getSunAngle"}, at={@At(value="HEAD")}, cancellable=true)
        private void interceptSunAngle(float partialTick, CallbackInfoReturnable<Float> cir) {
            if (ClientTimeInterpolator.isCurrentlyIntercepting()) {
                return;
            }
            ClientLevel level = this.time_slow$getCurrentLevel();
            if (level == null) {
                return;
            }
            float multiplier = ClientTimeInterpolator.getTimeMultiplier(level);
            if (Math.abs(multiplier - 1.0f) > 0.01f) {
                float interpolatedSunAngle = ClientTimeInterpolator.getInterpolatedSunAngle(level, partialTick);
                cir.setReturnValue((Object)Float.valueOf(interpolatedSunAngle));
            }
        }
    }

    @Mixin(value={CropBlock.class})
    public static abstract class CropAccelerationMixin {
        @Shadow
        public abstract int m_52305_(BlockState var1);

        @Shadow
        public abstract int m_7419_();

        @Shadow
        protected static float m_52272_(Block p_52273_, BlockGetter p_52274_, BlockPos p_52275_) {
            return 0.0f;
        }

        @Shadow
        public abstract BlockState m_52289_(int var1);

        @Inject(method={"randomTick"}, at={@At(value="HEAD")})
        private void accelerateCropGrowth(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
            float multiplier = TimeAccelerationCore.getSpeedMultiplier(level);
            if (multiplier > 1.0f) {
                int extraTicks = (int)(multiplier - 1.0f);
                for (int i = 0; i < extraTicks; ++i) {
                    if (!(random.m_188501_() < 0.3f)) continue;
                    this.myRandomTick(state, level, pos, random);
                }
            }
        }

        public void myRandomTick(BlockState p_221050_, ServerLevel p_221051_, BlockPos p_221052_, RandomSource p_221053_) {
            float f;
            int i;
            if (p_221051_.isAreaLoaded(p_221052_, 1) && p_221051_.m_45524_(p_221052_, 0) >= 9 && (i = this.m_52305_(p_221050_)) < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)p_221051_, (BlockPos)p_221052_, (BlockState)p_221050_, (p_221053_.m_188503_((int)(25.0f / (f = CropAccelerationMixin.m_52272_((Block)((CropBlock)this), (BlockGetter)p_221051_, p_221052_))) + 1) == 0 ? 1 : 0) != 0)) {
                p_221051_.m_7731_(p_221052_, this.m_52289_(i + 1), 2);
                ForgeHooks.onCropsGrowPost((Level)p_221051_, (BlockPos)p_221052_, (BlockState)p_221050_);
            }
        }
    }

    @Mixin(value={MinecraftServer.class})
    public static class FrameRateIndependentMixin {
        @Shadow
        protected long f_129726_;

        @Inject(method={"runServer"}, at={@At(value="HEAD")})
        private void adjustServerTiming(CallbackInfo ci) {
            MinecraftServer server = (MinecraftServer)this;
            boolean hasAcceleration = false;
            float maxMultiplier = 1.0f;
            for (ServerLevel level : server.m_129785_()) {
                float multiplier = TimeAccelerationCore.getSpeedMultiplier(level);
                if (multiplier == 1.0f) continue;
                hasAcceleration = true;
                maxMultiplier = Math.max(maxMultiplier, multiplier);
            }
            if (hasAcceleration && maxMultiplier > 1.0f) {
                long normalTickTime = 50L;
                long adjustedTickTime = (long)((float)normalTickTime / Math.min(maxMultiplier, 2.0f));
                this.f_129726_ = System.currentTimeMillis() + adjustedTickTime;
            }
        }
    }

    @Mixin(value={LevelRenderer.class})
    public static abstract class LevelRendererMixin {
        @Shadow
        private ClientLevel f_109465_;
        @Shadow
        private int f_109477_;
        @Shadow
        private int f_109430_;
        @Shadow
        private int f_109431_;
        @Shadow
        private int f_109432_;
        @Shadow
        private Vec3 f_109433_;
        @Shadow
        private CloudStatus f_109435_;
        @Shadow
        private boolean f_109474_;
        @Shadow
        private VertexBuffer f_109475_;
        @Final
        @Shadow
        private Minecraft f_109461_;
        @Shadow
        @Final
        private static ResourceLocation f_109456_;

        @Shadow
        protected abstract BufferBuilder.RenderedBuffer m_234261_(BufferBuilder var1, double var2, double var4, double var6, Vec3 var8);

        @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
        private void renderClouds(PoseStack poseStack, Matrix4f matrix4f, float partialTick, double cameraX, double cameraY, double cameraZ, CallbackInfo callbackInfo) {
            float cloudHeight;
            boolean needsAcceleration;
            float timeMultiplier = ClientTimeInterpolator.getTimeMultiplier(this.f_109465_);
            boolean bl = needsAcceleration = Math.abs(timeMultiplier - 1.0f) > 0.01f;
            if (!needsAcceleration) {
                return;
            }
            callbackInfo.cancel();
            if (!this.f_109465_.m_104583_().renderClouds(this.f_109465_, this.f_109477_, partialTick, poseStack, cameraX, cameraY, cameraZ, matrix4f) && !Float.isNaN(cloudHeight = this.f_109465_.m_104583_().m_108871_())) {
                RenderSystem.disableCull();
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.depthMask((boolean)true);
                long interpolatedTime = ClientTimeInterpolator.getInterpolatedDayTime(this.f_109465_);
                double effectiveTime = (double)interpolatedTime + (double)partialTick / 1000.0;
                double d1 = effectiveTime * 0.03;
                double d2 = (cameraX + d1) / 12.0;
                double d3 = cloudHeight - (float)cameraY + 0.33f;
                double d4 = cameraZ / 12.0 + 0.33;
                d2 -= (double)(Mth.m_14107_((double)(d2 / 2048.0)) * 2048);
                d4 -= (double)(Mth.m_14107_((double)(d4 / 2048.0)) * 2048);
                float f3 = (float)(d2 - (double)Mth.m_14107_((double)d2));
                float f4 = (float)(d3 / 4.0 - (double)Mth.m_14107_((double)(d3 / 4.0))) * 4.0f;
                float f5 = (float)(d4 - (double)Mth.m_14107_((double)d4));
                Vec3 cloudColor = this.f_109465_.m_104808_(partialTick);
                int i = (int)Math.floor(d2);
                int j = (int)Math.floor(d3 / 4.0);
                int k = (int)Math.floor(d4);
                if (i != this.f_109430_ || j != this.f_109431_ || k != this.f_109432_ || this.f_109461_.f_91066_.m_92174_() != this.f_109435_ || this.f_109433_.m_82557_(cloudColor) > 2.0E-4) {
                    this.f_109430_ = i;
                    this.f_109431_ = j;
                    this.f_109432_ = k;
                    this.f_109433_ = cloudColor;
                    this.f_109435_ = this.f_109461_.f_91066_.m_92174_();
                    this.f_109474_ = true;
                }
                if (this.f_109474_) {
                    this.f_109474_ = false;
                    BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                    if (this.f_109475_ != null) {
                        this.f_109475_.close();
                    }
                    this.f_109475_ = new VertexBuffer(VertexBuffer.Usage.STATIC);
                    BufferBuilder.RenderedBuffer renderedBuffer = this.m_234261_(bufferBuilder, d2, d3, d4, cloudColor);
                    this.f_109475_.m_85921_();
                    this.f_109475_.m_231221_(renderedBuffer);
                    VertexBuffer.m_85931_();
                }
                RenderSystem.setShader(GameRenderer::m_172838_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_109456_);
                FogRenderer.m_109036_();
                poseStack.m_85836_();
                poseStack.m_85841_(12.0f, 1.0f, 12.0f);
                poseStack.m_252880_(-f3, f4, -f5);
                if (this.f_109475_ != null) {
                    int l;
                    this.f_109475_.m_85921_();
                    for (int i1 = l = this.f_109435_ == CloudStatus.FANCY ? 0 : 1; i1 < 2; ++i1) {
                        if (i1 == 0) {
                            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                        } else {
                            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                        }
                        ShaderInstance shaderInstance = RenderSystem.getShader();
                        if (shaderInstance == null) continue;
                        this.f_109475_.m_253207_(poseStack.m_85850_().m_252922_(), matrix4f, shaderInstance);
                    }
                    VertexBuffer.m_85931_();
                }
                poseStack.m_85849_();
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
            }
        }
    }

    @Mixin(value={DimensionType.class})
    public static class DimensionTypeMixin {
        @Inject(method={"timeOfDay"}, at={@At(value="HEAD")}, cancellable=true)
        private void interceptTimeOfDay(long partialTick, CallbackInfoReturnable<Float> cir) {
            if (ClientTimeInterpolator.isCurrentlyIntercepting()) {
                return;
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            float multiplier = ClientTimeInterpolator.getTimeMultiplier(level);
            if (Math.abs(multiplier - 1.0f) > 0.01f) {
                float interpolatedTimeOfDay = ClientTimeInterpolator.getInterpolatedTimeOfDay(level, partialTick);
                cir.setReturnValue((Object)Float.valueOf(interpolatedTimeOfDay));
            }
        }
    }

    @Mixin(value={ServerLevel.class})
    public static class SimpleTimeMixin {
        @Unique
        private static final Map<ServerLevel, Float> time_slow$timeDebt = new ConcurrentHashMap<ServerLevel, Float>();
        @Unique
        private static final Map<ServerLevel, Float> time_slow$randomTickDebt = new ConcurrentHashMap<ServerLevel, Float>();

        @Inject(method={"tickTime"}, at={@At(value="TAIL")})
        private void addGentleTimeAcceleration(CallbackInfo ci) {
            ServerLevel level = (ServerLevel)this;
            float multiplier = TimeAccelerationCore.getSpeedMultiplier(level);
            if (multiplier > 1.0f) {
                float extraTime = multiplier - 1.0f;
                float currentTimeDebt = time_slow$timeDebt.getOrDefault(level, Float.valueOf(0.0f)).floatValue();
                if ((currentTimeDebt += extraTime) >= 1.0f) {
                    this.performGentleTimeTick(level);
                    currentTimeDebt -= 1.0f;
                }
                time_slow$timeDebt.put(level, Float.valueOf(currentTimeDebt));
                float currentRandomTickDebt = time_slow$randomTickDebt.getOrDefault(level, Float.valueOf(0.0f)).floatValue();
                currentRandomTickDebt += extraTime;
                if (currentRandomTickDebt >= 1.0f) {
                    this.performExtraRandomTicks(level, multiplier);
                    currentRandomTickDebt -= 1.0f;
                }
                time_slow$randomTickDebt.put(level, Float.valueOf(currentRandomTickDebt));
            } else {
                time_slow$timeDebt.remove(level);
                time_slow$randomTickDebt.remove(level);
            }
        }

        @Unique
        private void performGentleTimeTick(ServerLevel level) {
            if (!level.m_46469_().m_46207_(GameRules.f_46140_)) {
                return;
            }
            level.m_8615_(level.m_46468_() + 1L);
        }

        @Unique
        private void performExtraRandomTicks(ServerLevel level, float multiplier) {
            int baseRandomTickSpeed = level.m_46469_().m_46215_(GameRules.f_46143_);
            if (baseRandomTickSpeed <= 0) {
                return;
            }
            float tickMultiplier = (float)Math.sqrt(multiplier);
            int adjustedRandomTickSpeed = Math.max(1, Math.round((float)baseRandomTickSpeed * tickMultiplier));
            level.m_7726_().f_8325_.m_140416_().forEach(holder -> {
                LevelChunk chunk = holder.m_140085_();
                if (chunk != null) {
                    this.performChunkRandomTicks(level, chunk, adjustedRandomTickSpeed);
                }
            });
        }

        @Unique
        private void performChunkRandomTicks(ServerLevel level, LevelChunk chunk, int randomTickSpeed) {
            ChunkPos chunkPos = chunk.m_7697_();
            LevelChunkSection[] sections = chunk.m_7103_();
            for (int sectionIndex = 0; sectionIndex < sections.length; ++sectionIndex) {
                LevelChunkSection section = sections[sectionIndex];
                if (section == null || section.m_188008_()) continue;
                int sectionBottomY = level.m_141937_() + sectionIndex * 16;
                for (int i = 0; i < randomTickSpeed; ++i) {
                    int x = level.f_46441_.m_188503_(16) + chunkPos.m_45604_();
                    int z = level.f_46441_.m_188503_(16) + chunkPos.m_45605_();
                    int y = level.f_46441_.m_188503_(16) + sectionBottomY;
                    if (y < level.m_141937_() || y > level.m_151558_()) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState blockState = section.m_62982_(x & 0xF, y & 0xF, z & 0xF);
                    if (!blockState.m_60823_()) continue;
                    try {
                        blockState.m_222972_(level, pos, level.f_46441_);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Mixin(value={BrewingStandBlockEntity.class})
    public static class BrewingStandAccelerationMixin {
        @Unique
        private static final Map<BrewingStandBlockEntity, Float> time_slow$brewDebt = new ConcurrentHashMap<BrewingStandBlockEntity, Float>();

        @Inject(method={"serverTick"}, at={@At(value="HEAD")})
        private static void accelerateBrewing(Level level, BlockPos pos, BlockState state, BrewingStandBlockEntity brewingStand, CallbackInfo ci) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                float multiplier = TimeAccelerationCore.getSpeedMultiplier(serverLevel);
                if (multiplier > 1.0f && brewingStand.f_58976_ > 0) {
                    float extraBrewTime = multiplier - 1.0f;
                    float currentDebt = time_slow$brewDebt.getOrDefault(brewingStand, Float.valueOf(0.0f)).floatValue();
                    if ((currentDebt += extraBrewTime) >= 1.0f) {
                        int extraTicks = (int)currentDebt;
                        brewingStand.f_58976_ = Math.max(0, brewingStand.f_58976_ - extraTicks);
                        currentDebt -= (float)extraTicks;
                    }
                    time_slow$brewDebt.put(brewingStand, Float.valueOf(currentDebt));
                } else {
                    time_slow$brewDebt.remove(brewingStand);
                }
            }
        }
    }
}

