/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.wzz.time_slow.GuardianMod;
import net.wzz.time_slow.util.TimeDataHandler;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SyncTimeManipulatorPacket {
    private final UUID playerId;
    public TimeDataHandler data;

    public SyncTimeManipulatorPacket(UUID playerId, TimeDataHandler timeDataHandler) {
        this.playerId = playerId;
        this.data = timeDataHandler;
    }

    public SyncTimeManipulatorPacket(FriendlyByteBuf buf) {
        this.playerId = buf.m_130259_();
        this.data = new TimeDataHandler();
        this.data.read(buf.m_130260_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerId);
        buf.m_130079_(this.data.save(new CompoundTag()));
    }

    public static void handle(SyncTimeManipulatorPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                msg.data.setTimeManipulator(msg.playerId);
                TimeDataHandler.handler = msg.data;
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GuardianMod.addNetworkMessage(SyncTimeManipulatorPacket.class, SyncTimeManipulatorPacket::encode, SyncTimeManipulatorPacket::new, SyncTimeManipulatorPacket::handle, NetworkDirection.PLAY_TO_CLIENT);
    }
}

