/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.wzz.time_slow.GuardianMod;
import net.wzz.time_slow.event.ClientTimeInterpolator;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TimeSpeedSyncPacket {
    private final ResourceLocation dimensionKey;
    private final float speedMultiplier;

    public TimeSpeedSyncPacket(ResourceLocation dimensionKey, float speedMultiplier) {
        this.dimensionKey = dimensionKey;
        this.speedMultiplier = speedMultiplier;
    }

    public static void encode(TimeSpeedSyncPacket packet, FriendlyByteBuf buf) {
        buf.m_130085_(packet.dimensionKey);
        buf.writeFloat(packet.speedMultiplier);
    }

    public static TimeSpeedSyncPacket decode(FriendlyByteBuf buf) {
        ResourceLocation dimensionKey = buf.m_130281_();
        float speedMultiplier = buf.readFloat();
        return new TimeSpeedSyncPacket(dimensionKey, speedMultiplier);
    }

    public static void handle(TimeSpeedSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                TimeSpeedSyncPacket.h(packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void h(TimeSpeedSyncPacket packet) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ != null && minecraft.f_91073_.m_46472_().m_135782_().equals((Object)packet.dimensionKey)) {
            ClientLevel level = minecraft.f_91073_;
            ClientTimeInterpolator.setTimeMultiplier(level, packet.speedMultiplier);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GuardianMod.addNetworkMessage(TimeSpeedSyncPacket.class, TimeSpeedSyncPacket::encode, TimeSpeedSyncPacket::decode, TimeSpeedSyncPacket::handle);
    }
}

