/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.network.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.wzz.time_slow.GuardianMod;

public class NetworkHandler {
    public static void sendToNearbyPlayers(Object packet, Level level, Vec3 position, double radius) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List players = serverLevel.m_8795_(player -> player.m_20275_(position.f_82479_, position.f_82480_, position.f_82481_) < radius * radius);
            for (ServerPlayer player2 : players) {
                GuardianMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), packet);
            }
        }
    }

    public static void sendToNearbyPlayers(Object packet, Entity entity, double radius) {
        NetworkHandler.sendToNearbyPlayers(packet, entity.m_9236_(), entity.m_20182_(), radius);
    }

    public static void sendToServer(Object packet) {
        GuardianMod.PACKET_HANDLER.sendToServer(packet);
    }

    public static void sendToServerSafe(Object packet) {
        if (Minecraft.m_91087_().m_91403_() != null) {
            GuardianMod.PACKET_HANDLER.sendToServer(packet);
        }
    }

    public static void sendToPlayer(Object packet, ServerPlayer player) {
        GuardianMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static void sendToAllPlayers(Object packet) {
        GuardianMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), packet);
    }

    public static void safeSendToAll(Object packet, boolean fromClient) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            GuardianMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), packet);
        } else if (fromClient) {
            GuardianMod.PACKET_HANDLER.sendToServer(packet);
        }
    }

    public static void sendToAllPlayer(Level level, Object object) {
        MinecraftServer mcServer;
        if (!level.m_5776_() && (mcServer = ServerLifecycleHooks.getCurrentServer()) != null && !mcServer.m_6846_().m_11314_().isEmpty()) {
            for (ServerPlayer serverPlayer : mcServer.m_6846_().m_11314_()) {
                NetworkHandler.send(PacketDistributor.PLAYER.with(() -> serverPlayer), object);
            }
        }
    }

    public static void sendToAllPlayerWith(Level level, Object object, ServerPlayer source) {
        MinecraftServer mcServer;
        if (!level.m_5776_() && (mcServer = ServerLifecycleHooks.getCurrentServer()) != null && !mcServer.m_6846_().m_11314_().isEmpty()) {
            for (ServerPlayer serverPlayer : mcServer.m_6846_().m_11314_()) {
                if (serverPlayer == source) continue;
                NetworkHandler.send(PacketDistributor.PLAYER.with(() -> serverPlayer), object);
            }
        }
    }

    public static void send(PacketDistributor.PacketTarget target, Object object) {
        GuardianMod.PACKET_HANDLER.send(target, object);
    }

    public static void sendToTrackingEntity(Object packet, Entity entity) {
        GuardianMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), packet);
    }

    public static void sendToTrackingEntityAndSelf(Object packet, Entity entity) {
        GuardianMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), packet);
    }

    public static void sendToDimension(Object packet, ResourceKey<Level> dimension) {
        GuardianMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> dimension), packet);
    }

    public static void sendToAllAround(Object packet, Vec3 pos, double radius, ResourceKey<Level> dimension) {
        GuardianMod.PACKET_HANDLER.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(pos.f_82479_, pos.f_82480_, pos.f_82481_, radius, dimension)), packet);
    }

    public static ServerPlayer getSender(Supplier<NetworkEvent.Context> ctx) {
        return ctx.get().getSender();
    }

    public static void handlePacket(Supplier<NetworkEvent.Context> ctx, Runnable serverHandler, Runnable clientHandler) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                serverHandler.run();
            } else {
                clientHandler.run();
            }
        });
        context.setPacketHandled(true);
    }

    public static List<String> readStringList(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(buf.m_130277_());
        }
        return list;
    }

    public static void writeStringList(FriendlyByteBuf buf, List<String> list) {
        buf.writeInt(list.size());
        for (String s : list) {
            buf.m_130070_(s);
        }
    }
}

