/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.wzz.time_slow.init.ModRenderType;

@OnlyIn(value=Dist.CLIENT)
public class RendererUtils {
    public static void renderDistortionField(PoseStack poseStack, MultiBufferSource bufferSource) {
        poseStack.m_85836_();
        VertexConsumer consumer = bufferSource.m_6299_(ModRenderType.GUI_END_GATEWAY);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.depthMask((boolean)false);
        RendererUtils.renderDistortionSphere(poseStack, consumer);
        RenderSystem.depthMask((boolean)true);
        poseStack.m_85849_();
    }

    private static void renderDistortionSphere(PoseStack poseStack, VertexConsumer consumer) {
        PoseStack.Pose pose = poseStack.m_85850_();
        int segments = 16;
        float radius = 25.0f;
        for (int i = 0; i < segments; ++i) {
            for (int j = 0; j < segments; ++j) {
                float lat1 = (float)Math.PI * (float)i / (float)segments;
                float lat2 = (float)Math.PI * (float)(i + 1) / (float)segments;
                float lng1 = (float)Math.PI * 2 * (float)j / (float)segments;
                float lng2 = (float)Math.PI * 2 * (float)(j + 1) / (float)segments;
                float x1 = (float)((double)radius * Math.sin(lat1) * Math.cos(lng1));
                float y1 = (float)((double)radius * Math.cos(lat1));
                float z1 = (float)((double)radius * Math.sin(lat1) * Math.sin(lng1));
                float x2 = (float)((double)radius * Math.sin(lat1) * Math.cos(lng2));
                float y2 = (float)((double)radius * Math.cos(lat1));
                float z2 = (float)((double)radius * Math.sin(lat1) * Math.sin(lng2));
                float x3 = (float)((double)radius * Math.sin(lat2) * Math.cos(lng2));
                float y3 = (float)((double)radius * Math.cos(lat2));
                float z3 = (float)((double)radius * Math.sin(lat2) * Math.sin(lng2));
                float x4 = (float)((double)radius * Math.sin(lat2) * Math.cos(lng1));
                float y4 = (float)((double)radius * Math.cos(lat2));
                float z4 = (float)((double)radius * Math.sin(lat2) * Math.sin(lng1));
                float u1 = (float)j / (float)segments;
                float v1 = (float)i / (float)segments;
                float u2 = (float)(j + 1) / (float)segments;
                float v2 = (float)(i + 1) / (float)segments;
                float r = 1.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a = 0.5f;
                RendererUtils.addDistortionVertex(consumer, pose, x1, y1, z1, r, g, b, a, u1, v1, 0xF000F0);
                RendererUtils.addDistortionVertex(consumer, pose, x2, y2, z2, r, g, b, a, u2, v1, 0xF000F0);
                RendererUtils.addDistortionVertex(consumer, pose, x3, y3, z3, r, g, b, a, u2, v2, 0xF000F0);
                RendererUtils.addDistortionVertex(consumer, pose, x4, y4, z4, r, g, b, a, u1, v2, 0xF000F0);
            }
        }
    }

    private static void addDistortionVertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, float r, float g, float b, float a, float u, float v, int lightLevel) {
        consumer.m_252986_(pose.m_252922_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_85969_(lightLevel).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

