/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.util;

import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class RainbowText {
    private static final ChatFormatting[] colour = new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.YELLOW, ChatFormatting.AQUA, ChatFormatting.BLUE, ChatFormatting.LIGHT_PURPLE, ChatFormatting.DARK_PURPLE};

    private static String formatting(String input, ChatFormatting[] colours, double delay) {
        StringBuilder sb = new StringBuilder(input.length() * 3);
        if (delay <= 0.0) {
            delay = 0.001;
        }
        int offset = (int)Math.floor((double)(System.currentTimeMillis() & 0x3FFFL) / delay) % colours.length;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            sb.append(colours[(colours.length + i - offset) % colours.length].toString());
            sb.append(c);
        }
        return sb.toString();
    }

    public static MutableComponent rgb(String text) {
        MutableComponent result = Component.m_237119_();
        long time = System.currentTimeMillis();
        int baseHue = (int)(time / 10L % 1000L);
        for (int i = 0; i < text.length(); ++i) {
            int hue = (baseHue + i * 15) % 360;
            int rgb = Color.HSBtoRGB((float)hue / 360.0f, 1.0f, 1.0f);
            Style style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb));
            result.m_7220_((Component)Component.m_237113_((String)String.valueOf(text.charAt(i))).m_130948_(style));
        }
        return result;
    }

    public static String makeColour(String input) {
        return RainbowText.formatting(input, colour, 80.0);
    }
}

