/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.wzz.time_slow.network.SyncTimeManipulatorPacket;
import net.wzz.time_slow.network.util.NetworkHandler;

public class TimeDataHandler {
    private static final Map<Integer, Float> uniformCache = new HashMap<Integer, Float>();
    private static final Map<Integer, Integer> uniformICache = new HashMap<Integer, Integer>();
    private float timeMultiplier = 1.0f;
    private float pausePartialTick;
    private boolean timestop;
    private UUID timeManipulator = UUID.randomUUID();
    public int stopTime;
    public int soundTick;
    public static TimeDataHandler handler = new TimeDataHandler();

    public void setTimeManipulator(Entity entity) {
        this.timeManipulator = entity.m_20148_();
    }

    public void setTimeManipulator(UUID uuid) {
        this.timeManipulator = uuid;
    }

    public void removeTimeManipulator() {
        this.timeManipulator = UUID.randomUUID();
    }

    public boolean canTimeStopped() {
        return this.timestop;
    }

    public void setTimeStopped(boolean stopped) {
        this.timestop = stopped;
    }

    public static float processUniformValue(int location, float value) {
        if (!TimeDataHandler.get().canTimeStopped()) {
            return value;
        }
        return uniformCache.computeIfAbsent(location, k -> Float.valueOf(value)).floatValue();
    }

    public static int processUniformValue(int location, int value) {
        if (!TimeDataHandler.get().canTimeStopped()) {
            return value;
        }
        return uniformICache.computeIfAbsent(location, k -> value);
    }

    public void read(CompoundTag compoundTag) {
        if (compoundTag == null) {
            this.timestop = false;
            this.timeManipulator = UUID.randomUUID();
            this.stopTime = Integer.MAX_VALUE;
            this.pausePartialTick = 0.0f;
            this.timeMultiplier = 1.0f;
            this.soundTick = 0;
            return;
        }
        this.timestop = compoundTag.m_128471_("TimeStop");
        this.timeManipulator = compoundTag.m_128342_("TimeManipulator");
        this.stopTime = compoundTag.m_128451_("StopTime");
        this.pausePartialTick = compoundTag.m_128457_("PausePartialTick");
        this.timeMultiplier = compoundTag.m_128457_("TimeMultiplier");
        this.soundTick = compoundTag.m_128451_("SoundTick");
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128379_("TimeStop", this.timestop);
        compoundTag.m_128362_("TimeManipulator", this.timeManipulator);
        compoundTag.m_128405_("StopTime", this.stopTime);
        compoundTag.m_128350_("PausePartialTick", this.pausePartialTick);
        compoundTag.m_128350_("TimeMultiplier", this.timeMultiplier);
        compoundTag.m_128405_("SoundTick", this.soundTick);
        return compoundTag;
    }

    public float getPausePartialTick() {
        return this.pausePartialTick;
    }

    public boolean canEntityBeStopped(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!this.timeManipulator.equals(entity.m_20148_())) {
            return true;
        }
        if (entity instanceof Player && !this.timeManipulator.equals(entity.m_20148_())) {
            return true;
        }
        return !this.timeManipulator.equals(entity.m_20148_());
    }

    public static TimeDataHandler get() {
        return handler;
    }

    public void syncData(Level level) {
        if (!level.m_5776_()) {
            NetworkHandler.sendToAllPlayer(level, new SyncTimeManipulatorPacket(this.timeManipulator, this));
        }
    }
}

