/*
 * Decompiled with CFR 0.152.
 */
package net.wzz.time_slow.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.wzz.time_slow.entity.DistortionFieldEntity;

public class Utils {
    public static boolean timeSlow;

    public static void playSound(LevelAccessor world, String s, Entity living) {
        if (world instanceof Level) {
            Level _level = (Level)world;
            if (!_level.m_5776_()) {
                _level.m_6269_(null, living, Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("time_slow:" + s))), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                _level.m_7785_(living.m_20185_(), living.m_20186_(), living.m_20189_(), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("time_slow:" + s))), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
        }
    }

    public static void playSound(LevelAccessor world, SoundEvent s, Entity living) {
        if (world instanceof Level) {
            Level _level = (Level)world;
            if (!_level.m_5776_()) {
                _level.m_6269_(null, living, s, SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                _level.m_7785_(living.m_20185_(), living.m_20186_(), living.m_20189_(), s, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
        }
    }

    public static void notHurtTime(LivingEntity living) {
        living.f_20916_ = 0;
        living.f_20917_ = 0;
        living.f_19864_ = false;
        living.f_19802_ = 0;
    }

    public static void resetHurtTime(LivingEntity living, int i) {
        living.f_20916_ = i;
        living.f_20917_ = i;
        living.f_19864_ = true;
        living.f_19802_ = i;
    }

    public static Entity[] findAllEntities(Entity player, double range) {
        Vec3 _center = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
        AABB boundingBox = new AABB(_center.f_82479_ - range, _center.f_82480_ - range, _center.f_82481_ - range, _center.f_82479_ + range, _center.f_82480_ + range, _center.f_82481_ + range);
        List<Entity> list = player.f_19853_.m_6443_(Entity.class, boundingBox, e -> true).stream().filter(entity -> entity != player).sorted(Comparator.comparingDouble(entity -> entity.m_20238_(_center))).toList();
        return list.toArray(new Entity[0]);
    }

    public static Entity[] findAllEntitiesWithSource(Entity player, double range) {
        Vec3 _center = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
        AABB boundingBox = new AABB(_center.f_82479_ - range, _center.f_82480_ - range, _center.f_82481_ - range, _center.f_82479_ + range, _center.f_82480_ + range, _center.f_82481_ + range);
        List<LivingEntity> _entfound = player.f_19853_.m_6443_(LivingEntity.class, boundingBox, e -> true).stream().filter(Objects::nonNull).sorted(Comparator.comparingDouble(entity -> entity.m_20238_(_center))).toList();
        return _entfound.toArray(new Entity[0]);
    }

    public static int findPlayerNumbers(LivingEntity player, double range) {
        Vec3 _center = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
        List _entfound = player.f_19853_.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(range), e -> true);
        int playerCount = 0;
        for (Entity entity : _entfound) {
            Player listPlayer;
            if (!(entity instanceof Player) || (listPlayer = (Player)entity) == player) continue;
            ++playerCount;
        }
        return playerCount;
    }

    public static void spawnParticles(Entity living, SimpleParticleType particleType, int number, double speed) {
        Level level = living.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int k = 0; k < number; ++k) {
                Random rand = new Random();
                serverLevel.m_8767_((ParticleOptions)particleType, living.m_20185_() + (double)(rand.nextFloat() * living.m_20205_() * 2.0f) - (double)living.m_20205_(), living.m_20186_() + (double)(rand.nextFloat() * living.m_20206_()), living.m_20189_() + (double)(rand.nextFloat() * living.m_20205_() * 2.0f) - (double)living.m_20205_(), 1, 0.0, 0.0, 0.0, speed);
            }
        }
    }

    public static int convertToInteger(Number number) {
        return number.intValue();
    }

    public static int effectPower(LivingEntity p, float f) {
        return Utils.convertToInteger(Float.valueOf(p.m_21233_() * f)) / 4 - 1;
    }

    public static void regenerationCheckOrAdd(LivingEntity living, int duration, int amplifier) {
        if (living.m_21023_(MobEffects.f_19605_)) {
            boolean should = false;
            for (MobEffectInstance mobEffectInstance : living.m_21220_()) {
                if (mobEffectInstance.m_19544_() != MobEffects.f_19605_ || mobEffectInstance.m_19557_() > 20) continue;
                should = true;
                break;
            }
            if (should) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration, amplifier));
            }
        } else {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration, amplifier));
        }
    }

    public static ItemStack[] getPlayerArmorStacks(Player player) {
        ItemStack[] armorStacks = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            armorStacks[i] = player.m_150109_().m_36052_(i);
        }
        return armorStacks;
    }

    public static List<MobEffect> getEffects(LivingEntity living, MobEffectCategory mobEffectCategory) {
        ArrayList<MobEffect> effects = new ArrayList<MobEffect>();
        for (MobEffectInstance effectInstance : living.m_21220_()) {
            MobEffect effect = effectInstance.m_19544_();
            if (effect.m_19483_() != mobEffectCategory) continue;
            effects.add(effect);
        }
        if (!effects.isEmpty()) {
            return effects;
        }
        return effects;
    }

    public static boolean isNether(Level level) {
        if (level == null) {
            return false;
        }
        return level.m_46472_() == Level.f_46429_;
    }

    public static LivingEntity findRandomLivingEntity(Entity entity1, double range) {
        if (entity1 == null) {
            return null;
        }
        Vec3 center = entity1.m_20182_();
        AABB boundingBox = new AABB(center.f_82479_ - range, center.f_82480_ - range, center.f_82481_ - range, center.f_82479_ + range, center.f_82480_ + range, center.f_82481_ + range);
        List<LivingEntity> entityList = entity1.f_19853_.m_6443_(Entity.class, boundingBox, e -> e instanceof LivingEntity && e != entity1).stream().map(entity -> (LivingEntity)entity).toList();
        if (!entityList.isEmpty()) {
            Random random = new Random();
            return entityList.get(random.nextInt(entityList.size()));
        }
        return null;
    }

    public static void spawnClientDistortionField(Player player) {
        if (!player.f_19853_.f_46443_) {
            DistortionFieldEntity entity = new DistortionFieldEntity(player.f_19853_);
            entity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            player.f_19853_.m_7967_((Entity)entity);
        }
    }

    public static List<ServerPlayer> getAllPlayer(MinecraftServer server) {
        ArrayList<Object> players = new ArrayList<ServerPlayer>();
        if (server == null) {
            return players;
        }
        players = new ArrayList(server.m_6846_().m_11314_());
        return players;
    }

    public static void reduceMaxHealth(LivingEntity entity) {
        AttributeInstance maxHealthAttr = entity.m_21051_(Attributes.f_22276_);
        if (maxHealthAttr != null && maxHealthAttr.m_22111_(UUID.fromString("b3447554-6c75-4585-bd8b-8ce9b85f5412")) == null) {
            AttributeModifier healthReduction = new AttributeModifier(UUID.fromString("b3447554-6c75-4585-bd8b-8ce9b85f5412"), "health_reduction_50_percent", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
            maxHealthAttr.m_22125_(healthReduction);
            if (entity.m_21223_() > entity.m_21233_()) {
                entity.m_21153_(entity.m_21233_());
            }
        }
    }

    public static int countEntities(Entity player, double range, Class<? extends Entity> entityType) {
        Entity[] entities = Utils.findAllEntities(player, range);
        int count = 0;
        for (Entity entity : entities) {
            if (!entityType.isInstance(entity)) continue;
            ++count;
        }
        return count;
    }

    public static void forceSetHealth(LivingEntity living, float f) {
        Utils.forceSetHealth(living, f, living.f_19853_.m_269111_().m_269341_());
    }

    public static void forceSetHealth(LivingEntity living, float f, DamageSource damageSource) {
        if (living == null) {
            return;
        }
        SynchedEntityData newData = living.f_19804_;
        float currentHealth = living.m_21223_();
        newData.m_135381_(LivingEntity.f_20961_, (Object)Float.valueOf(f));
        living.f_19804_ = newData;
        living.f_19804_.f_135348_ = true;
        if (currentHealth <= 0.0f && f <= 0.0f && !living.f_19853_.f_46443_ && living.m_20194_() != null && !(living instanceof Player)) {
            living.m_6668_(damageSource);
        }
    }
}

