/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.forge;

import dev.architectury.platform.forge.EventBuses;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.FTBQuestsTags;
import dev.ftb.mods.ftbquests.command.ChangeProgressArgument;
import dev.ftb.mods.ftbquests.command.QuestObjectArgument;
import dev.ftb.mods.ftbquests.forge.ClientSetup;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.task.forge.ForgeEnergyTask;
import java.util.Iterator;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="ftbquests")
public class FTBQuestsForge {
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256982_, (String)"ftbteams");
    private static final RegistryObject<SingletonArgumentInfo<ChangeProgressArgument>> CHANGE_PROGRESS = COMMAND_ARGUMENT_TYPES.register("change_progress", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(ChangeProgressArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(ChangeProgressArgument::changeProgress)));
    private static final RegistryObject<SingletonArgumentInfo<QuestObjectArgument>> QUEST_OBJECT = COMMAND_ARGUMENT_TYPES.register("quest_object", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(QuestObjectArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(QuestObjectArgument::new)));

    public FTBQuestsForge() {
        EventBuses.registerModEventBus((String)"ftbquests", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        COMMAND_ARGUMENT_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FTBQuests quests = new FTBQuests();
        ForgeEnergyTask.TYPE = TaskTypes.register(new ResourceLocation("ftbquests", "forge_energy"), ForgeEnergyTask::new, () -> Icon.getIcon((String)ForgeEnergyTask.EMPTY_TEXTURE.toString()).combineWith(Icon.getIcon((String)ForgeEnergyTask.FULL_TEXTURE.toString())));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> quests.setup());
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientSetup::init);
        MinecraftForge.EVENT_BUS.addListener(FTBQuestsForge::livingDrops);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, FTBQuestsForge::dropsEvent);
    }

    private static void livingDrops(LivingDropsEvent event) {
        LivingEntity living = event.getEntity();
        if (living.m_9236_().f_46443_ || living instanceof Player || living.m_6095_().m_204039_(FTBQuestsTags.EntityTypes.NO_LOOT_CRATES)) {
            return;
        }
        if (ServerQuestFile.INSTANCE == null || !ServerQuestFile.INSTANCE.isDropLootCrates()) {
            return;
        }
        ServerQuestFile.INSTANCE.makeRandomLootCrate((Entity)living, living.m_9236_().f_46441_).ifPresent(crate -> {
            ItemEntity itemEntity = new ItemEntity(living.m_9236_(), living.m_20185_(), living.m_20186_(), living.m_20189_(), crate.createStack());
            itemEntity.m_32010_(10);
            event.getDrops().add(itemEntity);
        });
    }

    private static void dropsEvent(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (player instanceof FakePlayer || player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemEntity drop = (ItemEntity)iterator.next();
            ItemStack stack = drop.m_32055_();
            if (stack.m_41720_() != FTBQuestsItems.BOOK.get() || !player.m_36356_(stack)) continue;
            iterator.remove();
        }
    }
}

