/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.integration.stages.StageHelper;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StageReward
extends Reward {
    private String stage = "";
    private boolean remove = false;

    public StageReward(long id, Quest quest) {
        super(id, quest);
        this.autoclaim = RewardAutoClaim.INVISIBLE;
    }

    @Override
    public RewardType getType() {
        return RewardTypes.STAGE;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("stage", this.stage);
        if (this.remove) {
            nbt.m_128379_("remove", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.stage = nbt.m_128461_("stage");
        this.remove = nbt.m_128471_("remove");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.stage, Short.MAX_VALUE);
        buffer.writeBoolean(this.remove);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.stage = buffer.m_130136_(Short.MAX_VALUE);
        this.remove = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.reward.ftbquests.gamestage");
        config.addBool("remove", this.remove, v -> {
            this.remove = v;
        }, false);
    }

    @Override
    public void claim(ServerPlayer player, boolean notify) {
        if (this.remove) {
            StageHelper.INSTANCE.getProvider().remove(player, this.stage);
        } else {
            StageHelper.INSTANCE.getProvider().add(player, this.stage);
        }
        if (notify) {
            if (this.remove) {
                player.m_240418_((Component)Component.m_237110_((String)"commands.gamestage.remove.target", (Object[])new Object[]{this.stage}), true);
            } else {
                player.m_240418_((Component)Component.m_237110_((String)"commands.gamestage.add.target", (Object[])new Object[]{this.stage}), true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.reward.ftbquests.gamestage").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)this.stage).m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public boolean ignoreRewardBlocking() {
        return true;
    }

    @Override
    protected boolean isIgnoreRewardBlockingHardcoded() {
        return true;
    }
}

