/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.brigadier.StringReader;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ObservationTask
extends AbstractBooleanTask {
    private long timer = 0L;
    private ObserveType observeType = ObserveType.BLOCK;
    private String toObserve = "minecraft:dirt";

    public ObservationTask(long id, Quest quest) {
        super(id, quest);
    }

    public void setToObserve(String toObserve) {
        this.toObserve = toObserve;
    }

    public long getTimer() {
        return this.timer;
    }

    @Override
    public TaskType getType() {
        return TaskTypes.OBSERVATION;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128356_("timer", this.timer);
        nbt.m_128405_("observe_type", this.observeType.ordinal());
        nbt.m_128359_("to_observe", this.toObserve);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.timer = nbt.m_128454_("timer");
        this.observeType = ObserveType.values()[nbt.m_128451_("observe_type")];
        this.toObserve = nbt.m_128461_("to_observe");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130103_(this.timer);
        buffer.m_130068_((Enum)this.observeType);
        buffer.m_130070_(this.toObserve);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.timer = buffer.m_130258_();
        this.observeType = (ObserveType)buffer.m_130066_(ObserveType.class);
        this.toObserve = buffer.m_130136_(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addLong("timer", this.timer, v -> {
            this.timer = v;
        }, 0L, 0L, 1200L);
        config.addEnum("observe_type", (Object)this.observeType, v -> {
            this.observeType = v;
        }, ObserveType.NAME_MAP);
        config.addString("to_observe", this.toObserve, v -> {
            this.toObserve = v;
        }, "minecraft:dirt");
    }

    @Override
    public Component getAltTitle() {
        return Component.m_237115_((String)"ftbquests.task.ftbquests.observation").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)this.toObserve).m_130940_(ChatFormatting.DARK_GREEN));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        return true;
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    public boolean observe(Player player, HitResult result) {
        if (this.toObserve.isEmpty()) {
            return false;
        }
        if (result instanceof BlockHitResult) {
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockInWorld blockInWorld = new BlockInWorld((LevelReader)player.m_9236_(), blockResult.m_82425_(), false);
            BlockState state = blockInWorld.m_61168_();
            Block block = state.m_60734_();
            BlockEntity blockEntity = blockInWorld.m_61174_();
            switch (this.observeType) {
                case BLOCK: {
                    return String.valueOf(RegistrarManager.getId((Object)block, (ResourceKey)Registries.f_256747_)).equals(this.toObserve);
                }
                case BLOCK_TAG: {
                    return this.asTagRL(this.toObserve).map(rl -> state.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)rl))).orElse(false);
                }
                case BLOCK_STATE: {
                    BlockInput stateMatch = this.tryMatchBlock(this.toObserve, false);
                    return stateMatch != null && stateMatch.test(blockInWorld);
                }
                case BLOCK_ENTITY: {
                    BlockInput stateNbtMatch = this.tryMatchBlock(this.toObserve, true);
                    return stateNbtMatch != null && stateNbtMatch.test(blockInWorld);
                }
                case BLOCK_ENTITY_TYPE: {
                    return blockEntity != null && this.toObserve.equals(String.valueOf(RegistrarManager.getId((Object)blockEntity.m_58903_(), (ResourceKey)Registries.f_256922_)));
                }
            }
            return false;
        }
        if (result instanceof EntityHitResult) {
            EntityHitResult entityResult = (EntityHitResult)result;
            if (this.observeType == ObserveType.ENTITY_TYPE) {
                return this.toObserve.equals(String.valueOf(RegistrarManager.getId((Object)entityResult.m_82443_().m_6095_(), (ResourceKey)Registries.f_256939_)));
            }
            if (this.observeType == ObserveType.ENTITY_TYPE_TAG) {
                return this.asTagRL(this.toObserve).map(rl -> entityResult.m_82443_().m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)rl))).orElse(false);
            }
        }
        return false;
    }

    private Optional<ResourceLocation> asTagRL(String str) {
        try {
            return Optional.of(new ResourceLocation(str.startsWith("#") ? str.substring(1) : str));
        }
        catch (ResourceLocationException e) {
            return Optional.empty();
        }
    }

    private BlockInput tryMatchBlock(String string, boolean parseNbt) {
        try {
            BlockStateParser.BlockResult blockStateParser = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(string), (boolean)false);
            return new BlockInput(blockStateParser.f_234748_(), blockStateParser.f_234749_().keySet(), parseNbt ? blockStateParser.f_234750_() : null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static enum ObserveType {
        BLOCK,
        BLOCK_TAG,
        BLOCK_STATE,
        BLOCK_ENTITY,
        BLOCK_ENTITY_TYPE,
        ENTITY_TYPE,
        ENTITY_TYPE_TAG;

        public static final NameMap<ObserveType> NAME_MAP;

        static {
            NAME_MAP = NameMap.of((Object)((Object)BLOCK), (Object[])ObserveType.values()).id(v -> v.name().toLowerCase()).create();
        }
    }
}

