/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.ChampionsOverlay;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.common.capability.ChampionCapability;

public class HUDHelper {
    private static final ResourceLocation GUI_BAR_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    private static final ResourceLocation GUI_STAR = new ResourceLocation("champions", "textures/gui/staricon.png");

    public static boolean renderHealthBar(GuiGraphics guiGraphics, LivingEntity livingEntity) {
        return ChampionCapability.getCapability(livingEntity).map(champion -> {
            IChampion.Client clientChampion = champion.getClient();
            return clientChampion.getRank().map(rank -> {
                int num = (Integer)rank.m_14418_();
                Set affixSet = clientChampion.getAffixes().stream().map(IAffix::getIdentifier).collect(Collectors.toSet());
                if (num > 0 || affixSet.size() > 0) {
                    Object name;
                    Minecraft client = Minecraft.m_91087_();
                    int i = client.m_91268_().m_85445_();
                    int k = i / 2 - 91;
                    int j = 21;
                    int xOffset = ClientChampionsConfig.hudXOffset;
                    int yOffset = ClientChampionsConfig.hudYOffset;
                    int color = (Integer)rank.m_14419_();
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BAR_TEXTURES);
                    ChampionsOverlay.startX = xOffset + k;
                    ChampionsOverlay.startY = yOffset + 1;
                    guiGraphics.m_280163_(GUI_BAR_TEXTURES, xOffset + k, yOffset + j, 0.0f, 60.0f, 182, 5, 256, 256);
                    int healthOffset = (int)(livingEntity.m_21223_() / livingEntity.m_21233_() * 183.0f);
                    if (healthOffset > 0) {
                        guiGraphics.m_280163_(GUI_BAR_TEXTURES, xOffset + k, yOffset + j, 0.0f, 65.0f, healthOffset, 5, 256, 256);
                    }
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_STAR);
                    if (num <= 18) {
                        startStarsX = xOffset + i / 2 - 5 - 5 * (num - 1);
                        for (int tier = 0; tier < num; ++tier) {
                            guiGraphics.m_280163_(GUI_STAR, startStarsX, yOffset + 1, 0.0f, 0.0f, 9, 9, 9, 9);
                            startStarsX += 10;
                        }
                    } else {
                        startStarsX = xOffset + i / 2 - 5;
                        String count = "x" + num;
                        guiGraphics.m_280163_(GUI_STAR, startStarsX - client.f_91062_.m_92895_(count) / 2, yOffset + 1, 0.0f, 0.0f, 9, 9, 9, 9);
                        guiGraphics.drawString(client.f_91062_, count, (float)(startStarsX + 10) - (float)client.f_91062_.m_92895_(count) / 2.0f, (float)(yOffset + 2), 0xFFFFFF, true);
                    }
                    Component customName = livingEntity.m_7770_();
                    if (customName == null) {
                        name = Component.m_237115_((String)("rank.champions.title." + num)).getString();
                        name = (String)name + " " + livingEntity.m_7755_().getString();
                    } else {
                        name = customName.getString();
                    }
                    guiGraphics.drawString(client.f_91062_, (String)name, (float)xOffset + (float)(i / 2 - client.f_91062_.m_92895_((String)name) / 2), (float)yOffset + (float)(j - 9), color, true);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    StringBuilder builder = new StringBuilder();
                    for (String affix : affixSet) {
                        builder.append(Component.m_237115_((String)("affix.champions." + affix)).getString());
                        builder.append(" ");
                    }
                    String affixes = builder.toString().trim();
                    guiGraphics.drawString(client.f_91062_, affixes, (float)xOffset + (float)(i / 2 - client.f_91062_.m_92895_(affixes) / 2), (float)yOffset + (float)(j + 6), 0xFFFFFF, true);
                    RenderSystem.disableBlend();
                    return true;
                }
                return false;
            }).orElse(false);
        }).orElse(false);
    }
}

