/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.registry.ModDamageTypes;

public class ReflectiveAffix
extends BasicAffix {
    public ReflectiveAffix() {
        super("reflective", AffixCategory.OFFENSE, true);
    }

    @SubscribeEvent
    public void onDamageEvent(LivingDamageEvent evt) {
        if (!ChampionsConfig.reflectiveLethal && evt.getSource().m_276093_(ModDamageTypes.REFLECTION_DAMAGE)) {
            LivingEntity living = evt.getEntity();
            float currentDamage = evt.getAmount();
            if (currentDamage >= living.m_21223_()) {
                evt.setAmount(living.m_21223_() - 1.0f);
            }
        }
    }

    @Override
    public float onDamage(IChampion champion, DamageSource source, float amount, float newAmount) {
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            Entity entity2;
            LivingEntity sourceEntity = (LivingEntity)entity;
            if (source.m_276093_(ModDamageTypes.REFLECTION_DAMAGE) || source.m_7639_() instanceof LivingEntity && source.m_269150_().m_203565_(DamageTypes.f_268440_)) {
                return newAmount;
            }
            DamageSources newSources = new DamageSources(champion.getLivingEntity().m_9236_().m_9598_());
            DamageSource newSource = newSources.m_269425_();
            float min = (float)ChampionsConfig.reflectiveMinPercent;
            float damage = (float)Math.min((double)amount * ((double)sourceEntity.m_217043_().m_188501_() * (ChampionsConfig.reflectiveMaxPercent - (double)min) + (double)min), (double)ChampionsConfig.reflectiveMax);
            if ((source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_)) && (entity2 = source.m_7639_()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity2;
                living.m_20254_(champion.getLivingEntity().m_20094_());
            }
            if (source.m_276093_(DamageTypes.f_268565_)) {
                newSource = newSources.m_269036_((Entity)sourceEntity, source.m_7640_());
            }
            if (source.m_276093_(DamageTypes.f_268515_)) {
                newSource = newSources.m_269425_();
            }
            if (source.m_7986_()) {
                newSource.m_7986_();
            }
            sourceEntity.m_6469_(newSource, damage);
        }
        return newAmount;
    }
}

