/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.capability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.ChampionEventsHandler;
import top.theillusivec4.champions.common.capability.CapabilityEventHandler;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.util.ChampionHelper;

public class ChampionCapability {
    public static final Capability<IChampion> CHAMPION_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChampion>(){});
    public static final ResourceLocation ID = new ResourceLocation("champions", "champion");
    private static final String AFFIX_TAG = "affixes";
    private static final String TIER_TAG = "tier";
    private static final String DATA_TAG = "data";
    private static final String ID_TAG = "identifier";

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ChampionEventsHandler());
    }

    public static Provider createProvider(LivingEntity livingEntity) {
        return new Provider(livingEntity);
    }

    @Deprecated
    public static LazyOptional<IChampion> getCapability(LivingEntity entity) {
        return ChampionCapability.getCapability((Entity)entity);
    }

    public static LazyOptional<IChampion> getCapability(Entity entity) {
        if (!ChampionHelper.isValidChampion(entity)) {
            return LazyOptional.empty();
        }
        return entity.getCapability(CHAMPION_CAP);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<IChampion> optional;
        final IChampion data;

        Provider(LivingEntity livingEntity) {
            this.data = new Champion(livingEntity);
            this.optional = LazyOptional.of(() -> this.data);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == CHAMPION_CAP ? this.optional.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            CompoundTag compoundNBT = new CompoundTag();
            IChampion.Server champion = this.data.getServer();
            champion.getRank().ifPresent(rank -> compoundNBT.m_128405_(ChampionCapability.TIER_TAG, rank.getTier()));
            List<IAffix> affixes = champion.getAffixes();
            ListTag list = new ListTag();
            affixes.forEach(affix -> {
                CompoundTag tag = new CompoundTag();
                String id = affix.getIdentifier();
                tag.m_128359_(ChampionCapability.ID_TAG, id);
                tag.m_128365_(ChampionCapability.DATA_TAG, (Tag)champion.getData(id));
                list.add((Object)tag);
            });
            compoundNBT.m_128365_(ChampionCapability.AFFIX_TAG, (Tag)list);
            return compoundNBT;
        }

        public void deserializeNBT(Tag nbt) {
            CompoundTag compoundNBT = (CompoundTag)nbt;
            IChampion.Server champion = this.data.getServer();
            if (compoundNBT.m_128441_(ChampionCapability.TIER_TAG)) {
                int tier = compoundNBT.m_128451_(ChampionCapability.TIER_TAG);
                champion.setRank(RankManager.getRank(tier));
            }
            if (compoundNBT.m_128441_(ChampionCapability.AFFIX_TAG)) {
                ListTag list = compoundNBT.m_128437_(ChampionCapability.AFFIX_TAG, 10);
                ArrayList<IAffix> affixes = new ArrayList<IAffix>();
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag tag = list.m_128728_(i);
                    String id = tag.m_128461_(ChampionCapability.ID_TAG);
                    Champions.API.getAffix(id).ifPresent(affix -> {
                        affixes.add((IAffix)affix);
                        if (tag.m_128403_(ChampionCapability.DATA_TAG)) {
                            champion.setData(id, tag.m_128469_(ChampionCapability.DATA_TAG));
                        }
                    });
                }
                champion.setAffixes(affixes);
            }
        }
    }

    public static class Champion
    implements IChampion {
        private final LivingEntity champion;
        private final Client client;
        private final Server server;

        private Champion(LivingEntity livingEntity) {
            this.champion = livingEntity;
            this.client = new Client();
            this.server = new Server();
        }

        @Override
        public Client getClient() {
            return this.client;
        }

        @Override
        public Server getServer() {
            return this.server;
        }

        @Override
        @Nonnull
        public LivingEntity getLivingEntity() {
            return this.champion;
        }

        public static class Client
        implements IChampion.Client {
            private final List<IAffix> affixes = new ArrayList<IAffix>();
            private final Map<String, IAffix> idToAffix = new HashMap<String, IAffix>();
            private final Map<String, CompoundTag> data = new HashMap<String, CompoundTag>();
            private Tuple<Integer, Integer> rank = null;

            @Override
            public Optional<Tuple<Integer, Integer>> getRank() {
                return Optional.ofNullable(this.rank);
            }

            @Override
            public void setRank(Tuple<Integer, Integer> rank) {
                this.rank = rank;
            }

            @Override
            public List<IAffix> getAffixes() {
                return Collections.unmodifiableList(this.affixes);
            }

            @Override
            public void setAffixes(Set<String> affixes) {
                this.affixes.clear();
                for (String affix : affixes) {
                    Champions.API.getAffix(affix).ifPresent(val -> {
                        this.affixes.add((IAffix)val);
                        this.idToAffix.put(val.getIdentifier(), (IAffix)val);
                    });
                }
            }

            @Override
            public Optional<IAffix> getAffix(String id) {
                return Optional.ofNullable(this.idToAffix.get(id));
            }

            @Override
            public void setData(String identifier, CompoundTag data) {
                this.data.put(identifier, data);
            }

            @Override
            public CompoundTag getData(String identifier) {
                return this.data.getOrDefault(identifier, new CompoundTag());
            }
        }

        public static class Server
        implements IChampion.Server {
            private final Map<String, CompoundTag> data = new HashMap<String, CompoundTag>();
            private Rank rank = null;
            private List<IAffix> affixes = new ArrayList<IAffix>();

            @Override
            public Optional<Rank> getRank() {
                return Optional.ofNullable(this.rank);
            }

            @Override
            public void setRank(Rank rank) {
                this.rank = rank;
            }

            @Override
            public List<IAffix> getAffixes() {
                return Collections.unmodifiableList(this.affixes);
            }

            @Override
            public void setAffixes(List<IAffix> affixes) {
                this.affixes = affixes;
            }

            @Override
            public void setData(String identifier, CompoundTag data) {
                this.data.put(identifier, data);
            }

            @Override
            public CompoundTag getData(String identifier) {
                return this.data.getOrDefault(identifier, new CompoundTag());
            }
        }
    }
}

