/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.integration.theoneprobe;

import java.util.function.Function;
import mcjty.theoneprobe.api.Color;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class TheOneProbePlugin
implements IProbeInfoEntityProvider {
    public String getID() {
        return "champions:entity.champion";
    }

    public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, Entity entity, IProbeHitEntityData probeHitEntityData) {
        if (ChampionsConfig.enableTOPIntegration) {
            ChampionCapability.getCapability(entity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                serverChampion.getRank().ifPresent(rank -> {
                    if (rank.getTier() == 0) {
                        return;
                    }
                    int color = rank.getDefaultColor();
                    int r = color >> 16 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color & 0xFF;
                    Color rankColor = new Color(r, g, b);
                    IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(rankColor).spacing(3).padding(3));
                    vertical.mcText((Component)Component.m_237115_((String)("rank.champions.title." + rank.getTier())).m_130946_(" (" + rank.getTier() + ")").m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_178520_(rank.getDefaultColor())));
                    for (IAffix affix : serverChampion.getAffixes()) {
                        IProbeInfo horizontal = vertical.horizontal();
                        horizontal.mcText((Component)Component.m_237115_((String)("affix.champions." + affix.getIdentifier())));
                    }
                });
            });
        }
    }

    public static final class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe input) {
            TheOneProbePlugin instance = new TheOneProbePlugin();
            input.registerEntityProvider((IProbeInfoEntityProvider)instance);
            return null;
        }
    }
}

