/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.util.FakePlayer;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.config.ConfigLoot;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.registry.ModLootModifiers;

public class ChampionLootModifier
extends LootModifier {
    public static final Codec<ChampionLootModifier> CODEC = RecordCodecBuilder.create(inst -> ChampionLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ChampionLootModifier::new));
    private static final ThreadLocal<Boolean> IS_PROCESSING = ThreadLocal.withInitial(() -> false);

    public ChampionLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (IS_PROCESSING.get().booleanValue()) {
            return generatedLoot;
        }
        IS_PROCESSING.set(true);
        try {
            Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
            if (entity == null) {
                ObjectArrayList<ItemStack> objectArrayList = generatedLoot;
                return objectArrayList;
            }
            DamageSource damageSource = (DamageSource)context.m_78953_(LootContextParams.f_81457_);
            if (damageSource == null) {
                ObjectArrayList<ItemStack> objectArrayList = generatedLoot;
                return objectArrayList;
            }
            if (!entity.m_9236_().m_46469_().m_46207_(GameRules.f_46135_) || !ChampionsConfig.fakeLoot && damageSource.m_7640_() instanceof FakePlayer) {
                ObjectArrayList<ItemStack> objectArrayList = generatedLoot;
                return objectArrayList;
            }
            ChampionCapability.getCapability(entity).ifPresent(champion -> {
                List<ItemStack> loot;
                IChampion.Server serverChampion = champion.getServer();
                ServerLevel serverWorld = (ServerLevel)entity.m_9236_();
                if (ChampionsConfig.lootSource != ConfigEnums.LootSource.CONFIG) {
                    LivingEntity livingEntity;
                    LivingEntity attackingEntity;
                    LootTable lootTable = serverWorld.m_7654_().m_278653_().m_278676_(ModLootModifiers.CHAMPION_LOOT.getId());
                    LootParams.Builder lootParamsBuilder = new LootParams.Builder(serverWorld).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_()).m_287239_(context.m_78945_());
                    if (entity instanceof LivingEntity && (attackingEntity = (livingEntity = (LivingEntity)entity).m_21232_()) instanceof Player) {
                        lootParamsBuilder = lootParamsBuilder.m_287286_(LootContextParams.f_81456_, (Object)((Player)attackingEntity)).m_287239_(((Player)attackingEntity).m_36336_());
                    }
                    LootParams lootParams = lootParamsBuilder.m_287235_(LootContextParamSets.f_81415_);
                    lootTable.m_287228_(lootParams, arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0));
                }
                if (ChampionsConfig.lootSource != ConfigEnums.LootSource.LOOT_TABLE && !(loot = ConfigLoot.getLootDrops(serverChampion.getRank().map(Rank::getTier).orElse(0))).isEmpty()) {
                    generatedLoot.addAll(loot);
                }
            });
            ObjectArrayList<ItemStack> objectArrayList = generatedLoot;
            return objectArrayList;
        }
        finally {
            IS_PROCESSING.set(false);
        }
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

