/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.exporbrecall.entity;

import com.jinqinxixi.exporbrecall.config.ParticleConfig;
import com.jinqinxixi.exporbrecall.network.ExpOrbParticlePacket;
import com.jinqinxixi.exporbrecall.network.ModMessages;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityExpOrb
extends ExperienceOrb {
    private static final double MIN_DISTANCE = 0.5;
    private static final double MIN_MOVEMENT = 0.01;
    private static final double INITIAL_Y_VELOCITY = 0.2;
    private static final double HORIZONTAL_SPREAD = 0.3;
    private static final double GRAVITY = 0.02;
    private static final double STEERING_FORCE = 0.15;
    private static final double MAX_SPEED = 1.2;
    private static final double DRAG = 0.015;
    private static final double INITIAL_PITCH = 0.35;
    private Vec3 velocity = Vec3.f_82478_;
    private Vec3 smoothedPosition;
    private boolean initialized = false;
    private int phase = 0;
    private Vec3 startPos;

    public EntityExpOrb(EntityType<? extends ExperienceOrb> type, Level level) {
        super(type, level);
    }

    public EntityExpOrb(Level level, double x, double y, double z, int value) {
        super(level, x, y, z, value);
        this.startPos = this.smoothedPosition = new Vec3(x, y, z);
        this.initializeMotion();
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            Player nearestPlayer = this.m_9236_().m_45930_((Entity)this, ((Double)ParticleConfig.TRACKING_RANGE.get()).doubleValue());
            if (nearestPlayer != null) {
                if (!this.initialized) {
                    this.startPos = this.m_20182_();
                    this.smoothedPosition = this.m_20182_();
                    this.initializeMotion();
                }
                this.customMovement(nearestPlayer);
            } else {
                super.m_8119_();
                return;
            }
        }
        super.m_8119_();
    }

    private void initializeMotion() {
        double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
        double speed = 0.3 * (1.2 + this.f_19796_.m_188500_() * 0.3);
        double horizontalSpeed = speed * Math.cos(0.35);
        double verticalSpeed = speed * Math.sin(0.35);
        this.velocity = new Vec3(Math.cos(angle) * horizontalSpeed, verticalSpeed + 0.2, Math.sin(angle) * horizontalSpeed);
        this.initialized = true;
        this.phase = 0;
    }

    private void customMovement(Player nearestPlayer) {
        Vec3 targetPos = nearestPlayer.m_20182_().m_82520_(0.0, 1.0, 0.0);
        double distance = this.m_20182_().m_82554_(targetPos);
        if (distance > 0.5) {
            Vec3 oldPos = this.m_20182_();
            if (this.phase == 0) {
                boolean tooHigh;
                this.velocity = this.velocity.m_82520_(0.0, -0.02, 0.0);
                this.velocity = this.velocity.m_82490_(0.985);
                boolean belowTarget = this.m_20182_().f_82480_ <= targetPos.f_82480_;
                boolean pastPeak = this.velocity.f_82480_ < -0.15;
                boolean bl = tooHigh = this.m_20182_().f_82480_ > this.startPos.f_82480_ + 2.5;
                if (belowTarget || pastPeak || tooHigh) {
                    this.phase = 1;
                    this.velocity = this.velocity.m_82490_(0.7);
                }
            } else {
                Vec3 toTarget = targetPos.m_82546_(this.m_20182_());
                double speedFactor = Math.min(1.0, distance / 12.0);
                double targetSpeed = 1.2 * (0.6 + speedFactor * 0.4);
                Vec3 desiredVelocity = toTarget.m_82541_().m_82490_(targetSpeed);
                Vec3 steeringForce = desiredVelocity.m_82546_(this.velocity).m_82490_(0.15 * (0.8 + speedFactor * 0.4));
                this.velocity = this.velocity.m_82549_(steeringForce).m_82490_(0.994);
            }
            double currentSpeed = this.velocity.m_82553_();
            if (currentSpeed > 1.2) {
                this.velocity = this.velocity.m_82541_().m_82490_(1.2);
            } else if (currentSpeed < 0.01) {
                this.velocity = this.velocity.m_82541_().m_82490_(0.01);
            }
            this.smoothedPosition = this.smoothedPosition.m_82549_(this.velocity);
            Vec3 currentPos = this.m_20182_();
            Vec3 finalPos = this.lerp(currentPos, this.smoothedPosition, 0.25);
            if (!this.m_9236_().f_46443_ && this.velocity.m_82556_() > 1.0E-4) {
                double particleYOffset = 0.2;
                Vec3 particlePos = new Vec3(finalPos.f_82479_, finalPos.f_82480_ + particleYOffset, finalPos.f_82481_);
                Vec3 oldParticlePos = new Vec3(oldPos.f_82479_, oldPos.f_82480_ + particleYOffset, oldPos.f_82481_);
                Vec3 particleMovement = particlePos.m_82546_(oldParticlePos);
                ExpOrbParticlePacket baseParticle = new ExpOrbParticlePacket(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleMovement.f_82479_, particleMovement.f_82480_, particleMovement.f_82481_);
                ModMessages.sendToPlayersNearSafe(baseParticle, finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, 64.0, this.m_9236_());
                if (this.phase == 1 && currentSpeed > 0.6) {
                    ExpOrbParticlePacket trailParticle = new ExpOrbParticlePacket(particlePos.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.1, particlePos.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * 0.1, particlePos.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.1, particleMovement.f_82479_ * 0.5, particleMovement.f_82480_ * 0.5, particleMovement.f_82481_ * 0.5);
                    ModMessages.sendToPlayersNearSafe(trailParticle, finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, 64.0, this.m_9236_());
                }
            }
            this.m_20256_(this.velocity);
            this.m_6034_(finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_);
            if (this.velocity.m_82556_() > 1.0E-4) {
                double horizontalDistance = Math.sqrt(this.velocity.f_82479_ * this.velocity.f_82479_ + this.velocity.f_82481_ * this.velocity.f_82481_);
                float targetXRot = (float)(Math.atan2(this.velocity.f_82480_, horizontalDistance) * 180.0 / Math.PI);
                float targetYRot = (float)(Math.atan2(this.velocity.f_82479_, this.velocity.f_82481_) * 180.0 / Math.PI);
                this.m_146926_(this.lerp(this.m_146909_(), targetXRot, 0.2f));
                this.m_146922_(this.lerp(this.m_146908_(), targetYRot, 0.2f));
            }
            this.f_19812_ = true;
        }
    }

    private Vec3 lerp(Vec3 start, Vec3 end, double factor) {
        return start.m_82490_(1.0 - factor).m_82549_(end.m_82490_(factor));
    }

    private float lerp(float start, float end, float factor) {
        return start + factor * (end - start);
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int steps, boolean teleport) {
        if (!teleport && steps > 0) {
            Vec3 newPos = new Vec3(this.m_20185_() + (x - this.m_20185_()) / (double)steps, this.m_20186_() + (y - this.m_20186_()) / (double)steps, this.m_20189_() + (z - this.m_20189_()) / (double)steps);
            this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            this.smoothedPosition = newPos;
        } else {
            this.m_6034_(x, y, z);
            this.smoothedPosition = new Vec3(x, y, z);
        }
        this.m_19915_(yRot, xRot);
    }
}

