/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.exporbrecall.network;

import com.jinqinxixi.exporbrecall.config.ParticleConfig;
import com.jinqinxixi.exporbrecall.network.ExpOrbParticlePacket;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ClientParticleHandler {
    @OnlyIn(value=Dist.CLIENT)
    public static void handleParticles(ExpOrbParticlePacket msg) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            float[] colors = ClientParticleHandler.calculateColors(level.m_46467_());
            ParticleConfig.ParticleType currentType = (ParticleConfig.ParticleType)((Object)ParticleConfig.PARTICLE_TYPE.get());
            float size = currentType == ParticleConfig.ParticleType.DUST || currentType == ParticleConfig.ParticleType.DUST_COLOR_TRANSITION ? ((Double)ParticleConfig.PARTICLE_SIZE.get()).floatValue() : 1.0f;
            SimpleParticleType particleType = switch (currentType) {
                default -> throw new IncompatibleClassChangeError();
                case ParticleConfig.ParticleType.DUST -> new DustParticleOptions(new Vector3f(colors[0], colors[1], colors[2]), size);
                case ParticleConfig.ParticleType.DUST_COLOR_TRANSITION -> new DustColorTransitionOptions(new Vector3f(colors[0], colors[1], colors[2]), new Vector3f(colors[0] * ((Double)ParticleConfig.TRANSITION_ALPHA.get()).floatValue(), colors[1] * ((Double)ParticleConfig.TRANSITION_ALPHA.get()).floatValue(), colors[2] * ((Double)ParticleConfig.TRANSITION_ALPHA.get()).floatValue()), size);
                case ParticleConfig.ParticleType.ENTITY_EFFECT -> ParticleTypes.f_123811_;
                case ParticleConfig.ParticleType.AMBIENT_ENTITY_EFFECT -> ParticleTypes.f_123770_;
                case ParticleConfig.ParticleType.NOTE -> ParticleTypes.f_123758_;
            };
            int particleCount = (Integer)ParticleConfig.PARTICLE_COUNT.get();
            for (int i = 0; i < particleCount; ++i) {
                double spread = 0.02;
                level.m_7106_((ParticleOptions)particleType, msg.getX() + (Math.random() - 0.5) * spread, msg.getY() + (Math.random() - 0.5) * spread, msg.getZ() + (Math.random() - 0.5) * spread, (double)colors[0], (double)colors[1], (double)colors[2]);
            }
        }
    }

    private static float[] calculateColors(long worldTime) {
        if (((Boolean)ParticleConfig.RAINBOW_MODE.get()).booleanValue()) {
            float cycleTime = ((Double)ParticleConfig.RAINBOW_CYCLE_TIME.get()).floatValue();
            float ticksPerCycle = cycleTime * 20.0f;
            float colorStep = (float)Math.PI * 2 / ticksPerCycle;
            float hue = ((float)Math.sin((float)worldTime * colorStep) + 1.0f) / 2.0f;
            Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
            return new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        }
        return new float[]{(float)((Integer)ParticleConfig.RED.get()).intValue() / 255.0f, (float)((Integer)ParticleConfig.GREEN.get()).intValue() / 255.0f, (float)((Integer)ParticleConfig.BLUE.get()).intValue() / 255.0f};
    }
}

