/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.datapackloaderrorfix.handler;

import com.xinian.datapackloaderrorfix.service.CleanupService;
import java.lang.reflect.Field;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="datapackloaderrorfix", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class GuiScreenEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component BUTTON_TEXT = Component.m_237115_((String)"gui.datapackloaderrorfix.BUTTON_TEXT");
    private static final Component SUCCESS_TEXT = Component.m_237115_((String)"gui.datapackloaderrorfix.SUCCESS_TEXT");
    private static final Component FAILURE_TEXT = Component.m_237115_((String)"gui.datapackloaderrorfix.FAILURE_TEXT");
    private static Field levelAccessField = null;

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof EditWorldScreen) {
            EditWorldScreen editWorldScreen = (EditWorldScreen)screen;
            Button cleanButton = Button.m_253074_((Component)BUTTON_TEXT, button -> {
                button.f_93623_ = false;
                GuiScreenEventHandler.handleCleanButtonClick(editWorldScreen, button);
            }).m_252987_(screen.f_96543_ / 2 - 100, screen.f_96544_ - 56, 200, 20).m_253136_();
            event.addListener((GuiEventListener)cleanButton);
        }
    }

    private static void handleCleanButtonClick(EditWorldScreen screen, Button button) {
        LevelStorageSource.LevelStorageAccess levelAccess = GuiScreenEventHandler.getLevelAccess(screen);
        if (levelAccess == null) {
            LOGGER.error("\u65e0\u6cd5\u83b7\u53d6\u4e16\u754c\u5b58\u6863\u4fe1\u606f(levelAccess)\uff0c\u6e05\u7406\u64cd\u4f5c\u4e2d\u6b62\u3002");
            button.f_93623_ = true;
            return;
        }
        String levelId = levelAccess.m_78277_();
        LOGGER.info("\u5f00\u59cb\u624b\u52a8\u6e05\u7406\u4e16\u754c\u6570\u636e: {}", (Object)levelId);
        ((CompletableFuture)new CleanupService().cleanupWorldAsync(levelAccess.getWorldDir().toFile()).thenRun(() -> {
            LOGGER.info("\u4e16\u754c\u6570\u636e\u6e05\u7406\u6210\u529f: {}", (Object)levelId);
            Minecraft.m_91087_().execute(() -> {
                screen.getMinecraft().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.WORLD_BACKUP, SUCCESS_TEXT, null));
                button.f_93623_ = true;
            });
        })).exceptionally(ex -> {
            LOGGER.error("\u4e16\u754c\u6570\u636e\u6e05\u7406\u5931\u8d25: {}", (Object)levelId, ex);
            Minecraft.m_91087_().execute(() -> {
                screen.getMinecraft().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.WORLD_BACKUP, FAILURE_TEXT, (Component)Component.m_237113_((String)ex.getMessage())));
                button.f_93623_ = true;
            });
            return null;
        });
    }

    private static LevelStorageSource.LevelStorageAccess getLevelAccess(EditWorldScreen screen) {
        try {
            if (levelAccessField == null) {
                Field field = EditWorldScreen.class.getDeclaredField("levelAccess");
                field.setAccessible(true);
                levelAccessField = field;
            }
            return (LevelStorageSource.LevelStorageAccess)levelAccessField.get(screen);
        }
        catch (Exception e) {
            LOGGER.error("\u53cd\u5c04\u5931\u8d25\uff1a\u65e0\u6cd5\u627e\u5230\u6216\u8bbf\u95ee 'levelAccess' \u5b57\u6bb5\u3002", (Throwable)e);
            return null;
        }
    }
}

