/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.AbstractSpellData;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import org.slf4j.Logger;

public class Global {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ThreadLocal<Boolean> IN_REDIRECT = ThreadLocal.withInitial(() -> false);
    public static ArrayList<BiFunction<LivingHurtEvent, EntityMaid, Void>> common_damageProcessors = new ArrayList<BiFunction<LivingHurtEvent, EntityMaid, Void>>(){
        {
            this.add((event, maid) -> {
                LivingEntity entity = event.getEntity();
                if (entity instanceof EntityMaid) {
                    event.setCanceled(true);
                } else if (entity instanceof Player) {
                    event.setCanceled(true);
                }
                return null;
            });
        }
    };
    public static final HashMap<UUID, Deque<RedirectTicket>> hairpinTickets = new HashMap();
    public static ArrayList<BiFunction<LivingDamageEvent, Player, Void>> player_hurtProcessors_aft = new ArrayList<BiFunction<LivingDamageEvent, Player, Void>>(){
        {
            this.add((event, player) -> {
                DamageSource source = event.getSource();
                Deque<RedirectTicket> queue = hairpinTickets.get(player.m_20148_());
                if (queue == null || queue.isEmpty()) {
                    return null;
                }
                long now = player.m_9236_().m_46467_();
                DamageKey key = DamageKey.build((LivingEntity)player, source);
                Iterator<RedirectTicket> it = queue.iterator();
                while (it.hasNext()) {
                    RedirectTicket ticket = it.next();
                    if (ticket.expireTick < now) {
                        it.remove();
                        continue;
                    }
                    if (!ticket.key.equals(key)) continue;
                    it.remove();
                    EntityMaid maid = maidInfos.computeIfAbsent(player.m_20148_(), k -> new HashMap()).getOrDefault(ticket.maidUUID, null);
                    if (maid != null) {
                        try {
                            IN_REDIRECT.set(true);
                            maid.m_6469_(source, event.getAmount());
                        }
                        finally {
                            IN_REDIRECT.set(false);
                        }
                    } else {
                        LOGGER.debug("[hairpin] maid not found for ticket, maidUUID={}", (Object)ticket.maidUUID);
                    }
                    event.setCanceled(true);
                    break;
                }
                return null;
            });
        }
    };
    public static final HashMap<UUID, HashMap<UUID, EntityMaid>> maidInfos = new HashMap();
    public static ArrayList<BiFunction<LivingHurtEvent, EntityMaid, Void>> common_hurtProcessors = new ArrayList();
    public static ArrayList<Function<AbstractSpellData.CoolDown, Void>> common_coolDownProcessors = new ArrayList();
    public static Map<String, BiFunction<LivingDamageEvent, EntityMaid, Void>> bauble_damageProcessors_aft = new HashMap<String, BiFunction<LivingDamageEvent, EntityMaid, Void>>();
    public static Map<String, BiFunction<LivingHurtEvent, EntityMaid, Void>> bauble_damageProcessors_pre = new HashMap<String, BiFunction<LivingHurtEvent, EntityMaid, Void>>();
    public static Map<String, BiFunction<LivingHurtEvent, EntityMaid, Void>> bauble_hurtProcessors_pre = new HashMap<String, BiFunction<LivingHurtEvent, EntityMaid, Void>>();
    public static Map<String, BiFunction<LivingDamageEvent, EntityMaid, Void>> bauble_hurtProcessors_aft = new HashMap<String, BiFunction<LivingDamageEvent, EntityMaid, Void>>();
    public static Map<String, Function<AbstractSpellData.CoolDown, Void>> bauble_coolDownProcessors = new HashMap<String, Function<AbstractSpellData.CoolDown, Void>>();
    public static Map<String, BiFunction<MobEffectEvent.Added, EntityMaid, Void>> bauble_effectAddedProcessors = new HashMap<String, BiFunction<MobEffectEvent.Added, EntityMaid, Void>>();

    public static final class RedirectTicket {
        public final UUID maidUUID;
        public final DamageKey key;
        public final long expireTick;

        public RedirectTicket(UUID maidUUID, DamageKey key, long expireTick) {
            this.maidUUID = maidUUID;
            this.key = key;
            this.expireTick = expireTick;
        }
    }

    public static final class DamageKey {
        public final UUID attackerUUID;
        public final UUID directUUID;
        public final String msgId;
        public final long tick;

        private DamageKey(UUID attackerUUID, UUID directUUID, String msgId, long tick) {
            this.attackerUUID = attackerUUID;
            this.directUUID = directUUID;
            this.msgId = msgId;
            this.tick = tick;
        }

        public static DamageKey build(LivingEntity victim, DamageSource source) {
            UUID uUID;
            UUID uUID2;
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                uUID2 = le.m_20148_();
            } else {
                uUID2 = null;
            }
            UUID a = uUID2;
            Entity entity2 = source.m_7640_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity2;
                uUID = le.m_20148_();
            } else {
                uUID = null;
            }
            UUID d = uUID;
            String m = source.m_19385_();
            long t = victim.m_9236_().m_46467_();
            return new DamageKey(a, d, m, t);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DamageKey damageKey = (DamageKey)o;
            return this.tick == damageKey.tick && Objects.equals(this.attackerUUID, damageKey.attackerUUID) && Objects.equals(this.directUUID, damageKey.directUUID) && Objects.equals(this.msgId, damageKey.msgId);
        }

        public int hashCode() {
            return Objects.hash(this.attackerUUID, this.directUUID, this.msgId, this.tick);
        }
    }
}

