/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.manager.SpellBookManager;
import com.mojang.logging.LogUtils;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import org.slf4j.Logger;

public class SimplifiedSpellCaster {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final EntityMaid maid;
    private LivingEntity target;
    public static double MELEE_RANGE;
    public static double FAR_RANGE;
    private static final double MOVEMENT_SPEED = 0.6;
    private SpellBookManager spellBookManager;

    public SimplifiedSpellCaster(EntityMaid maid) {
        this.maid = maid;
        this.spellBookManager = SpellBookManager.getOrCreateManager(maid);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        if (this.spellBookManager != null) {
            for (ISpellBookProvider provider : this.spellBookManager.getProviders()) {
                provider.setTarget(this.maid, target);
            }
        }
    }

    public boolean hasValidTarget() {
        return this.target != null && this.target.m_6084_();
    }

    public void melee_tick() {
        if (!this.hasValidTarget()) {
            return;
        }
        SimplifiedSpellCaster.clearLookTarget(this.maid);
        if (this.maid.f_19797_ % 8 == 0) {
            double distance = this.maid.m_20270_((Entity)this.target);
            this.executeCombat(distance);
        }
    }

    public void far_tick() {
        if (!this.hasValidTarget()) {
            return;
        }
        SimplifiedSpellCaster.clearLookTarget(this.maid);
        if (this.maid.f_19797_ % 5 == 0) {
            double distance = this.maid.m_20270_((Entity)this.target);
            this.executeCombatFar(distance);
        }
    }

    public static void clearLookTarget(EntityMaid maid) {
        maid.m_6274_().m_21952_(MemoryModuleType.f_26371_).ifPresent(lookTarget -> {
            EntityTracker tracker;
            Entity patt3106$temp;
            if (lookTarget instanceof EntityTracker && (patt3106$temp = (tracker = (EntityTracker)lookTarget).m_147481_()) instanceof Player) {
                Player player = (Player)patt3106$temp;
                maid.m_6274_().m_21936_(MemoryModuleType.f_26371_);
            }
        });
    }

    private void executeCombat(double distance) {
        if (this.target == null) {
            return;
        }
        this.target.f_19802_ = 0;
        if (this.spellBookManager != null) {
            this.spellBookManager.castSpell(this.maid);
        }
        if (SimplifiedSpellCaster.hasSlashArt(this.maid.m_21205_())) {
            return;
        }
        if (distance <= MELEE_RANGE + 1.0) {
            this.maid.m_7327_((Entity)this.target);
            this.maid.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    private void executeCombatFar(double distance) {
        if (this.target == null) {
            return;
        }
        this.target.f_19802_ = 0;
        if (this.spellBookManager != null) {
            this.spellBookManager.castSpell(this.maid);
        }
    }

    public static boolean hasSlashArt(ItemStack itemStack) {
        if (!ModList.get().isLoaded("slashblade")) {
            return false;
        }
        if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof ItemSlashBlade)) {
            return false;
        }
        if (itemStack.m_41720_() instanceof ItemSlashBlade) {
            return true;
        }
        return itemStack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getSlashArtsKey() != null && !state.getSlashArtsKey().equals((Object)SlashArtsRegistry.NONE.getId())).orElse(false);
    }
}

