/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.manager;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.providers.ArsNouveauProvider;
import com.github.yimeng261.maidspell.spell.providers.GoetyProvider;
import com.github.yimeng261.maidspell.spell.providers.IronsSpellbooksProvider;
import com.github.yimeng261.maidspell.spell.providers.PsiProvider;
import com.github.yimeng261.maidspell.spell.providers.SlashBladeProvider;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.slf4j.Logger;

public class SpellBookManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, SpellBookManager> MAID_MANAGERS = new ConcurrentHashMap<UUID, SpellBookManager>();
    private static final List<ISpellBookProvider> instanceProviders = new ArrayList<ISpellBookProvider>();
    public static final List<String> loadedMods = new ArrayList<String>();
    private EntityMaid maid;

    private static void initializeProviderFactories() {
        LOGGER.info("Initializing spell book provider factories...");
        SpellBookManager.registerProviderFactoryByClassName("irons_spellbooks", "IronsSpellbooksProvider", IronsSpellbooksProvider.class);
        SpellBookManager.registerProviderFactoryByClassName("ars_nouveau", "ArsNouveauProvider", ArsNouveauProvider.class);
        SpellBookManager.registerProviderFactoryByClassName("goety", "GoetyProvider", GoetyProvider.class);
        SpellBookManager.registerProviderFactoryByClassName("psi", "PsiProvider", PsiProvider.class);
        SpellBookManager.registerProviderFactoryByClassName("slashblade", "SlashBladeProvider", SlashBladeProvider.class);
    }

    private static void registerProviderFactoryByClassName(String modId, String providerName, Class<?> providerClass) {
        try {
            if (ModList.get().isLoaded(modId)) {
                instanceProviders.add((ISpellBookProvider)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                loadedMods.add(modId);
                LOGGER.debug("Mod {} loaded, finished {} registration", (Object)modId, (Object)providerName);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to register provider factory for mod {}: {}", (Object)modId, (Object)e.getMessage());
        }
    }

    private SpellBookManager(EntityMaid maid) {
        this.maid = maid;
    }

    public static SpellBookManager getOrCreateManager(EntityMaid maid) {
        if (maid == null) {
            LOGGER.warn("Attempted to get manager for null maid entity");
            return null;
        }
        UUID maidUUID = maid.m_20148_();
        return MAID_MANAGERS.computeIfAbsent(maidUUID, uuid -> {
            LOGGER.debug("Creating new SpellBookManager for maid {}", uuid);
            return new SpellBookManager(maid);
        });
    }

    public static boolean removeManager(EntityMaid maid) {
        if (maid == null) {
            return false;
        }
        UUID maidUUID = maid.m_20148_();
        SpellBookManager removed = MAID_MANAGERS.remove(maidUUID);
        if (removed != null) {
            LOGGER.debug("Removed SpellBookManager for maid {}", (Object)maidUUID);
            return true;
        }
        return false;
    }

    public ISpellBookProvider getProvider(ItemStack itemStack) {
        for (ISpellBookProvider provider : instanceProviders) {
            if (!provider.isSpellBook(itemStack)) continue;
            return provider;
        }
        return null;
    }

    public boolean castSpell(EntityMaid maid) {
        boolean success = false;
        for (ISpellBookProvider provider : instanceProviders) {
            if (!provider.castSpell(maid)) continue;
            success = true;
        }
        return success;
    }

    public List<ISpellBookProvider> getProviders() {
        return new ArrayList<ISpellBookProvider>(instanceProviders);
    }

    public void stopAllCasting() {
        for (ISpellBookProvider provider : this.getProviders()) {
            if (!provider.isCasting(this.maid)) continue;
            provider.stopCasting(this.maid);
        }
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    public void setMaid(EntityMaid maid) {
        this.maid = maid;
    }

    public void updateCooldown() {
        for (ISpellBookProvider provider : instanceProviders) {
            provider.updateCooldown(this.maid);
        }
    }

    public Map<ISpellBookProvider, ItemStack> findSpellBooksInInventory() {
        HashMap<ISpellBookProvider, ItemStack> foundBooks = new HashMap<ISpellBookProvider, ItemStack>();
        CombinedInvWrapper availableInv = this.maid.getAvailableInv(false);
        ItemStack[] searchOrder = new ItemStack[availableInv.getSlots()];
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            searchOrder[i] = availableInv.getStackInSlot(i);
        }
        for (ItemStack stack : searchOrder) {
            if (stack == null || stack.m_41619_()) continue;
            for (ISpellBookProvider provider : instanceProviders) {
                if (!provider.isSpellBook(stack)) continue;
                if (provider.getClass().getSimpleName().equals("IronsSpellbooksProvider")) {
                    provider.setSpellBook(this.maid, stack);
                    continue;
                }
                if (foundBooks.containsKey(provider)) continue;
                foundBooks.put(provider, stack);
            }
        }
        return foundBooks;
    }

    public void tick() {
        for (ISpellBookProvider provider : this.getProviders()) {
            if (provider.getTarget(this.maid) != null) {
                provider.getTarget((EntityMaid)this.maid).f_19802_ = 0;
            }
            provider.processContinuousCasting(this.maid);
        }
        if (this.maid.f_19797_ % 20 == 0) {
            this.updateCooldown();
        }
    }

    public void updateSpellBooks() {
        for (ISpellBookProvider provider : this.getProviders()) {
            if (!provider.getClass().getSimpleName().equals("IronsSpellbooksProvider")) continue;
            provider.setSpellBook(this.maid, null);
            break;
        }
        Map<ISpellBookProvider, ItemStack> spellBooks = this.findSpellBooksInInventory();
        for (ISpellBookProvider provider : this.getProviders()) {
            if (provider.getClass().getSimpleName().equals("IronsSpellbooksProvider")) continue;
            ItemStack providerSpellBook = spellBooks.get(provider);
            if (providerSpellBook != null && !providerSpellBook.m_41619_()) {
                provider.setSpellBook(this.maid, providerSpellBook);
                continue;
            }
            provider.setSpellBook(this.maid, null);
        }
    }

    static {
        SpellBookManager.initializeProviderFactories();
    }
}

