/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.providers;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.SimplifiedSpellCaster;
import com.github.yimeng261.maidspell.spell.data.MaidSlashBladeData;
import com.mojang.logging.LogUtils;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.KnockBacks;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;

public class SlashBladeProvider
implements ISpellBookProvider {
    private static final Logger LOGGER = LogUtils.getLogger();

    private MaidSlashBladeData getData(EntityMaid maid) {
        return MaidSlashBladeData.getOrCreate(maid.m_20148_());
    }

    @Override
    public boolean isSpellBook(ItemStack itemStack) {
        return itemStack != null && !itemStack.m_41619_() && itemStack.m_41720_() instanceof ItemSlashBlade;
    }

    @Override
    public boolean castSpell(EntityMaid entityMaid) {
        return this.initiateCasting(entityMaid);
    }

    @Override
    public void updateCooldown(EntityMaid maid) {
        this.getData(maid).updateCooldowns();
    }

    @Override
    public void setTarget(EntityMaid maid, LivingEntity target) {
        MaidSlashBladeData data = this.getData(maid);
        data.setTarget(target);
        ItemStack slashBlade = maid.m_21205_();
        if (this.isSpellBook(slashBlade)) {
            slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                if (target != null && target.m_6084_()) {
                    state.setTargetEntityId(target.m_19879_());
                }
            });
        }
    }

    @Override
    public LivingEntity getTarget(EntityMaid maid) {
        return this.getData(maid).getTarget();
    }

    @Override
    public void setSpellBook(EntityMaid maid, ItemStack slashBlade) {
        this.getData(maid).setSlashBlade(slashBlade);
    }

    @Override
    public boolean isCasting(EntityMaid maid) {
        return this.getData(maid).isCasting();
    }

    @Override
    public boolean initiateCasting(EntityMaid maid) {
        ItemStack itemStack = maid.m_21205_();
        if (!this.isSpellBook(itemStack)) {
            return false;
        }
        MaidSlashBladeData data = this.getData(maid);
        if (maid.m_6117_()) {
            return false;
        }
        LivingEntity target = data.getTarget();
        if (data.isOnCooldown().booleanValue() || !this.hasSlashArt(itemStack)) {
            if ((double)maid.m_20270_((Entity)target) < SimplifiedSpellCaster.MELEE_RANGE) {
                this.performSlashBladeAttack(maid, itemStack);
            } else {
                maid.m_21573_().m_5624_((Entity)target, 0.6);
            }
            return false;
        }
        return itemStack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
            if (state.isBroken() || state.isSealed()) {
                return false;
            }
            this.ensureInputStateCapability(maid);
            maid.m_6672_(InteractionHand.MAIN_HAND);
            data.setCasting(true);
            data.setSAExecutionStartTime(maid.m_9236_().m_46467_());
            data.setTargetUseTime(state.getFullChargeTicks((LivingEntity)maid) + 5);
            return true;
        }).orElse(false);
    }

    @Override
    public void processContinuousCasting(EntityMaid maid) {
        MaidSlashBladeData data = this.getData(maid);
        ItemStack slashBlade = maid.m_21205_();
        if (!this.isSpellBook(slashBlade)) {
            return;
        }
        if (data.isOnCooldown().booleanValue() || !data.isCasting()) {
            return;
        }
        if (maid.m_6117_()) {
            int ticksUsing = maid.m_21252_();
            if (ticksUsing >= data.getTargetUseTime()) {
                this.triggerSlashArt(maid, slashBlade);
            } else {
                slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                    LivingEntity target = data.getTarget();
                    if (target != null && target.m_6084_()) {
                        BehaviorUtils.m_22595_((LivingEntity)maid, (LivingEntity)target);
                        Vec3 targetEyePos = target.m_146892_();
                        maid.m_7618_(EntityAnchorArgument.Anchor.EYES, targetEyePos);
                    }
                    slashBlade.m_41720_().m_6883_(slashBlade, maid.m_9236_(), (Entity)maid, 0, true);
                });
            }
        } else {
            this.processComboExecution(maid, slashBlade);
        }
    }

    @Override
    public void stopCasting(EntityMaid maid) {
        ItemStack slashBlade;
        MaidSlashBladeData data = this.getData(maid);
        if (maid.m_6117_()) {
            maid.m_21253_();
        }
        if (this.isSpellBook(slashBlade = maid.m_21205_())) {
            slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                state.setComboSeq(ComboStateRegistry.NONE.getId());
                state.setLastActionTime(maid.m_9236_().m_46467_());
            });
        }
        data.reset();
        if (data.getCooldown() < -40) {
            data.setCooldown(100);
        }
    }

    private void triggerSlashArt(EntityMaid maid, ItemStack slashBlade) {
        int ticksUsing = maid.m_21252_();
        int useDuration = slashBlade.m_41779_();
        int timeLeft = Math.max(0, useDuration - ticksUsing);
        slashBlade.m_41674_(maid.m_9236_(), (LivingEntity)maid, timeLeft);
        maid.m_5810_();
        slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            ResourceLocation currentCombo = state.getComboSeq();
            if (!currentCombo.equals((Object)ComboStateRegistry.NONE.getId())) {
                MaidSlashBladeData data = this.getData(maid);
                data.setSAExecutionStartTime(maid.m_9236_().m_46467_());
            } else {
                this.stopCasting(maid);
            }
        });
    }

    public boolean hasSlashArt(ItemStack itemStack) {
        if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof ItemSlashBlade)) {
            return false;
        }
        return itemStack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getSlashArtsKey() != null && !state.getSlashArtsKey().equals((Object)SlashArtsRegistry.NONE.getId())).orElse(false);
    }

    private void processComboExecution(EntityMaid maid, ItemStack slashBlade) {
        MaidSlashBladeData data = this.getData(maid);
        long currentTime = maid.m_9236_().m_46467_();
        long executionTime = currentTime - data.getSAExecutionStartTime();
        if (executionTime > 200L) {
            LOGGER.debug("SA execution timeout, forcing stop");
            this.stopCasting(maid);
            return;
        }
        slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            ResourceLocation lastCombo;
            ResourceLocation currentCombo = state.getComboSeq();
            if (currentCombo.equals((Object)ComboStateRegistry.NONE.getId())) {
                this.stopCasting(maid);
                return;
            }
            LivingEntity target = data.getTarget();
            if (target != null && target.m_6084_()) {
                BehaviorUtils.m_22595_((LivingEntity)maid, (LivingEntity)target);
            }
            if ((lastCombo = data.getLastComboState()) != null && lastCombo.equals((Object)currentCombo)) {
                this.stopCasting(maid);
                return;
            }
            data.setLastComboState(currentCombo);
            ComboState comboState = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(currentCombo);
            if (comboState != null) {
                slashBlade.m_41720_().m_6883_(slashBlade, maid.m_9236_(), (Entity)maid, 0, true);
            } else {
                this.stopCasting(maid);
            }
        });
    }

    private void ensureInputStateCapability(EntityMaid maid) {
        boolean hasInputState = maid.getCapability(ItemSlashBlade.INPUT_STATE).isPresent();
        if (hasInputState) {
            maid.getCapability(ItemSlashBlade.INPUT_STATE).ifPresent(inputState -> inputState.getCommands().add(InputCommand.R_CLICK));
        }
    }

    private void performSlashBladeAttack(EntityMaid maid, ItemStack slashBlade) {
        int roll = maid.m_217043_().m_188503_(60) - 30;
        AttackManager.doSlash((LivingEntity)maid, (float)roll, (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)1.0, (KnockBacks)KnockBacks.smash);
        slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> state.setLastActionTime(maid.m_9236_().m_46467_()));
        maid.m_6674_(InteractionHand.MAIN_HAND);
    }
}

