/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.worldgen.structure;

import com.github.yimeng261.maidspell.worldgen.MaidSpellStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class HidenRetreatStructure
extends Structure {
    public static final Codec<HidenRetreatStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size)).apply((Applicative)instance, HidenRetreatStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final int size;
    private int height;
    private static final double MAX_TERRAIN_VARIANCE = 16.0;
    private static final int SAMPLES_PER_CHUNK = 5;

    public HidenRetreatStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int size) {
        super(settings);
        this.startPool = startPool;
        this.size = size;
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        BlockPos centerPos = new BlockPos(chunkPos.m_45604_() + 8, 0, chunkPos.m_45605_() + 8);
        if (!this.isValidGenerationLocation(context, chunkPos)) {
            return Optional.empty();
        }
        int groundHeight = context.f_226622_().m_223235_(centerPos.m_123341_(), centerPos.m_123343_(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_226629_(), context.f_226624_());
        BlockPos structurePos = new BlockPos(centerPos.m_123341_(), this.height, centerPos.m_123343_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)this.size, (BlockPos)structurePos, (boolean)false, Optional.empty(), (int)120);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)MaidSpellStructures.HIDEN_RETREAT.get();
    }

    private boolean isValidGenerationLocation(Structure.GenerationContext context, ChunkPos centerChunk) {
        ArrayList<Integer> heightSamples = new ArrayList<Integer>();
        int range = 2;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                ChunkPos checkChunk = new ChunkPos(centerChunk.f_45578_ + dx, centerChunk.f_45579_ + dz);
                int x = checkChunk.m_45604_() + 8;
                int z = checkChunk.m_45605_() + 8;
                int y = context.f_226622_().m_6337_();
                Holder biome = context.f_226623_().m_203407_(x >> 2, y >> 2, z >> 2, context.f_226624_().m_224579_());
                if (!biome.m_203565_(Biomes.f_271432_)) {
                    return false;
                }
                List<Integer> chunkHeightSamples = this.sampleChunkHeights(context, checkChunk);
                heightSamples.addAll(chunkHeightSamples);
            }
        }
        return this.isTerrainFlat(heightSamples);
    }

    private List<Integer> sampleChunkHeights(Structure.GenerationContext context, ChunkPos chunk) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        RandomSource random = RandomSource.m_216335_((long)chunk.m_45588_());
        int minX = chunk.m_45604_();
        int minZ = chunk.m_45605_();
        for (int i = 0; i < 5; ++i) {
            int x = minX + random.m_188503_(16);
            int z = minZ + random.m_188503_(16);
            int height = context.f_226622_().m_223235_(x, z, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_226629_(), context.f_226624_());
            heights.add(height);
        }
        return heights;
    }

    private boolean isTerrainFlat(List<Integer> heights) {
        if (heights.size() < 2) {
            return true;
        }
        double sum = 0.0;
        for (int height : heights) {
            sum += (double)height;
        }
        double mean = sum / (double)heights.size();
        this.height = (int)mean;
        double varianceSum = 0.0;
        for (int height : heights) {
            double diff = (double)height - mean;
            varianceSum += diff * diff;
        }
        double variance = varianceSum / (double)heights.size();
        return variance <= 16.0;
    }
}

