/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.block.StoveBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ICookingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IHeatingSource;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.blockentity.IProcessingBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.StoveContainer;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class StoveBlockEntity
extends ElectricityModuleLootBlockEntity
implements IProcessingBlock,
IHeatingSource,
IPowerSwitch,
IHomeControlDevice,
Nameable,
StackedContentsCompatible {
    public static final int[] INPUT_SLOTS = new int[]{0, 1, 2};
    public static final int[] OUTPUT_SLOTS = new int[]{3, 4, 5};
    public static final int DATA_POWERED = 0;
    public static final int DATA_ENABLED = 1;
    public static final int DATA_PROGRESS_1 = 2;
    public static final int DATA_PROGRESS_2 = 3;
    public static final int DATA_PROGRESS_3 = 4;
    public static final int DATA_TOTAL_PROGRESS_1 = 5;
    public static final int DATA_TOTAL_PROGRESS_2 = 6;
    public static final int DATA_TOTAL_PROGRESS_3 = 7;
    protected final ImmutableList<CookingSpace> spaces;
    protected boolean enabled;
    protected boolean processing;
    protected int totalProcessingTime;
    protected int processingTime;
    protected WeakReference<ICookingBlock> cookingBlockRef;
    protected boolean sync;
    @Nullable
    protected StoveContainer container;
    @Nullable
    protected Component name;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.isNodePowered() ? 1 : 0, value -> {});
        builder.add(1, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(2, () -> this.getCookingSpaces((int)0).bakingTime, value -> {});
        builder.add(3, () -> this.getCookingSpaces((int)1).bakingTime, value -> {});
        builder.add(4, () -> this.getCookingSpaces((int)2).bakingTime, value -> {});
        builder.add(5, () -> this.getCookingSpaces((int)0).totalBakingTime, value -> {});
        builder.add(6, () -> this.getCookingSpaces((int)1).totalBakingTime, value -> {});
        builder.add(7, () -> this.getCookingSpaces((int)2).totalBakingTime, value -> {});
    });

    public StoveBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.STOVE.get(), pos, state);
    }

    public StoveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 6);
        this.spaces = (ImmutableList)Util.m_137537_(() -> {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)3);
            IntStream.range(0, 3).forEach(i -> builder.add((Object)new CookingSpace(i, i + 3, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.OVEN_BAKING.get()))));
            return builder.build();
        });
    }

    private CookingSpace getCookingSpaces(int index) {
        return (CookingSpace)this.spaces.get(index);
    }

    @Override
    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return OUTPUT_SLOTS;
        }
        return INPUT_SLOTS;
    }

    @Override
    public int getEnergy() {
        return 0;
    }

    @Override
    public void addEnergy(int energy) {
    }

    @Override
    public boolean requiresEnergy() {
        return false;
    }

    @Override
    public int retrieveEnergy(boolean simulate) {
        return 0;
    }

    @Override
    public int updateAndGetTotalProcessingTime() {
        int time = 0;
        ICookingBlock block = this.getCookingBlock();
        if (block != null) {
            time = block.getTimeToCook();
        }
        if (this.totalProcessingTime != time) {
            this.totalProcessingTime = time;
        }
        return this.totalProcessingTime;
    }

    @Override
    public int getTotalProcessingTime() {
        return this.totalProcessingTime;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setProcessingTime(int time) {
        boolean changed = false;
        if (this.processingTime == 0 && time > this.processingTime) {
            ICookingBlock block = this.getCookingBlock();
            if (block != null) {
                block.onStartCooking();
            }
            this.processing = true;
            this.sync();
            changed = true;
        } else if (time == 0 && time < this.processingTime) {
            ICookingBlock block = this.getCookingBlock();
            if (block != null) {
                block.onStopCooking();
            }
            this.processing = false;
            this.sync();
            changed = true;
        }
        if (this.processingTime != time) {
            this.processingTime = time;
            changed = true;
        }
        if (changed) {
            this.m_6596_();
        }
    }

    @Override
    public void onCompleteProcess() {
        ICookingBlock block = this.getCookingBlock();
        if (block != null) {
            block.onCompleteCooking();
            this.processing = false;
            this.m_6596_();
            this.sync();
        }
    }

    @Override
    public boolean canProcess() {
        if (!this.isNodePowered() || !this.enabled) {
            return false;
        }
        ICookingBlock block = this.getCookingBlock();
        return block != null && block.canCook();
    }

    @Nullable
    public ICookingBlock getCookingBlock() {
        ServerLevel serverLevel;
        BlockEntity entity;
        Level level;
        if (this.cookingBlockRef != null) {
            ICookingBlock block = (ICookingBlock)this.cookingBlockRef.get();
            if (block != null && !block.getBlockEntity().m_58901_()) {
                return block;
            }
            this.cookingBlockRef = null;
        }
        if ((level = this.f_58857_) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_7702_(this.f_58858_.m_7494_())) instanceof ICookingBlock) {
            ICookingBlock cookingBlock = (ICookingBlock)entity;
            this.cookingBlockRef = new WeakReference<ICookingBlock>(cookingBlock);
            return cookingBlock;
        }
        return null;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StoveBlockEntity stove) {
        stove.processTick();
        stove.spaces.forEach(IProcessingBlock::processTick);
        if (stove.sync) {
            BlockEntityHelper.sendCustomUpdate((BlockEntity)stove, stove.m_5995_());
            stove.sync = false;
        }
    }

    protected Component m_6820_() {
        return Utils.translation("container", "stove", new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return Services.MENU.createStoveMenu(windowId, playerInventory, (Container)this, this.data);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        IContainerHolder holder;
        return menu instanceof IContainerHolder && (holder = (IContainerHolder)menu).container() == this;
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        Vec3 center = Vec3.m_82512_((Vec3i)this.f_58858_).m_231075_(((Direction)state.m_61143_((Property)StoveBlock.DIRECTION)).m_122424_(), 0.5);
        level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)ModSounds.BLOCK_STOVE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.m_188501_());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        Vec3 center = Vec3.m_82512_((Vec3i)this.f_58858_).m_231075_(((Direction)state.m_61143_((Property)StoveBlock.DIRECTION)).m_122424_(), 0.5);
        level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)ModSounds.BLOCK_STOVE_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.m_188501_());
        this.setDoorState(state, false);
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.m_58904_();
        if (level != null) {
            level.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)StoveBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    @Override
    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    public boolean isHeating() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)StoveBlock.LIT) && (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false;
    }

    public void onDestroyed(BlockPos pos) {
        BlockEntity blockEntity;
        Level level;
        if (this.isProcessing() && (level = this.m_58904_()) != null && (blockEntity = level.m_7702_(pos.m_7494_())) instanceof ICookingBlock) {
            ICookingBlock cooking = (ICookingBlock)blockEntity;
            cooking.onStopCooking();
        }
    }

    public void onNeighbourChanged() {
        this.container = null;
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.container = null;
    }

    @Nullable
    public WorldlyContainer getContainer() {
        if (this.container == null) {
            BlockEntity blockEntity;
            ICookingBlock cookingBlock = this.getCookingBlock();
            if (cookingBlock != null && (blockEntity = cookingBlock.getBlockEntity()) instanceof Container) {
                Container cookingContainer = (Container)blockEntity;
                this.container = new StoveContainer(this, cookingBlock, cookingContainer);
            }
        } else if (!this.container.isValid()) {
            this.container = null;
        }
        return this.container != null ? this.container : this;
    }

    protected void sync() {
        this.sync = true;
    }

    @Override
    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Processing", 1)) {
            this.processing = tag.m_128471_("Processing");
        }
        if (tag.m_128425_("TotalProcessingTime", 3)) {
            this.totalProcessingTime = tag.m_128451_("TotalProcessingTime");
        }
        if (tag.m_128425_("ProcessingTime", 3)) {
            this.processingTime = tag.m_128451_("ProcessingTime");
        }
        if (tag.m_128425_("Enabled", 1)) {
            this.enabled = tag.m_128471_("Enabled");
        }
        this.readCookingSpaces(tag);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Processing", this.processing);
        tag.m_128405_("TotalProcessingTime", this.totalProcessingTime);
        tag.m_128405_("ProcessingTime", this.processingTime);
        tag.m_128379_("Enabled", this.enabled);
        this.writeCookingSpaces(tag);
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)StoveBlock.POWERED) && (Boolean)state.m_61143_((Property)StoveBlock.POWERED) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)StoveBlock.POWERED)) {
            state = (BlockState)state.m_61124_((Property)StoveBlock.POWERED, (Comparable)Boolean.valueOf(powered));
        }
        if (state.m_61138_((Property)StoveBlock.LIT)) {
            state = (BlockState)state.m_61124_((Property)StoveBlock.LIT, (Comparable)Boolean.valueOf(powered && this.enabled));
        }
        this.f_58857_.m_7731_(this.f_58858_, state, 3);
    }

    @Override
    public void togglePower() {
        this.enabled = !this.enabled;
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)StoveBlock.LIT, (Comparable)Boolean.valueOf(this.isNodePowered() && this.enabled)), 3);
        this.m_6596_();
        this.sync();
    }

    @Override
    public BlockPos getDevicePos() {
        return this.f_58858_;
    }

    @Override
    public boolean isDeviceEnabled() {
        return this.enabled;
    }

    @Override
    public void toggleDeviceState() {
        this.enabled = !this.enabled;
        this.m_6596_();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
    }

    @Override
    public void setDeviceState(boolean enabled) {
        this.enabled = enabled;
        this.m_6596_();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
    }

    @Override
    public Component getDeviceName() {
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        return Components.SMART_DEVICE_STOVE;
    }

    public Component m_5446_() {
        return this.name != null ? this.name : this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    public void m_58638_(@Nullable Component name) {
        this.name = name;
    }

    private CompoundTag writeCookingSpaces(CompoundTag compound) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.spaces.size(); ++i) {
            CompoundTag tag = new CompoundTag();
            ((CookingSpace)this.spaces.get(i)).writeToTag(tag);
            tag.m_128405_("Position", i);
            list.add((Object)tag);
        }
        compound.m_128365_("CookingSpaces", (Tag)list);
        return compound;
    }

    private void readCookingSpaces(CompoundTag compound) {
        if (compound.m_128425_("CookingSpaces", 9)) {
            ListTag list = compound.m_128437_("CookingSpaces", 10);
            list.forEach(nbt -> {
                int position;
                CompoundTag tag = (CompoundTag)nbt;
                if (tag.m_128425_("Position", 3) && (position = tag.m_128451_("Position")) >= 0 && position < this.spaces.size()) {
                    ((CookingSpace)this.spaces.get(position)).readFromTag(tag);
                }
            });
        }
    }

    public void m_5809_(StackedContents contents) {
        for (ItemStack stack : this.items) {
            contents.m_36491_(stack);
        }
    }

    protected class CookingSpace
    implements IProcessingBlock {
        private final int inputIndex;
        private final int outputIndex;
        private final RecipeManager.CachedCheck<Container, ? extends ProcessingRecipe> inputRecipeCache;
        private int totalBakingTime;
        private int bakingTime;

        public CookingSpace(int inputIndex, int outputIndex, RecipeType<? extends ProcessingRecipe> recipeType) {
            this.inputIndex = inputIndex;
            this.outputIndex = outputIndex;
            this.inputRecipeCache = RecipeManager.m_220267_(recipeType);
        }

        @Override
        public int getEnergy() {
            return 0;
        }

        @Override
        public void addEnergy(int energy) {
        }

        @Override
        public boolean requiresEnergy() {
            return false;
        }

        @Override
        public int retrieveEnergy(boolean simulate) {
            return 0;
        }

        @Override
        public int updateAndGetTotalProcessingTime() {
            int time = 0;
            Optional<? extends ProcessingRecipe> optional = this.getRecipe();
            if (optional.isPresent()) {
                time = Math.max(time, optional.get().getTime());
            }
            if (this.totalBakingTime != time) {
                this.totalBakingTime = time;
            }
            return this.totalBakingTime;
        }

        @Override
        public int getTotalProcessingTime() {
            return this.totalBakingTime;
        }

        @Override
        public int getProcessingTime() {
            return this.bakingTime;
        }

        @Override
        public void setProcessingTime(int time) {
            this.bakingTime = time;
        }

        @Override
        public void onCompleteProcess() {
            ItemStack stack = StoveBlockEntity.this.m_8020_(this.inputIndex);
            if (!stack.m_41619_()) {
                Item remainingItem = stack.m_41741_() == 1 ? stack.m_41720_().m_41469_() : null;
                Optional<? extends ProcessingRecipe> optional = this.getRecipe();
                Level level = Objects.requireNonNull(StoveBlockEntity.this.m_58904_());
                ItemStack result = optional.map(recipe -> recipe.m_8043_(level.m_9598_())).orElse(ItemStack.f_41583_);
                stack.m_41774_(1);
                if (!result.m_41619_()) {
                    ItemStack copy = result.m_41777_();
                    ItemStack outputStack = StoveBlockEntity.this.m_8020_(this.outputIndex);
                    if (outputStack.m_41619_()) {
                        StoveBlockEntity.this.m_6836_(this.outputIndex, copy);
                    } else if (ItemStack.m_150942_((ItemStack)copy, (ItemStack)outputStack) && outputStack.m_41613_() + copy.m_41613_() <= outputStack.m_41741_()) {
                        outputStack.m_41769_(copy.m_41613_());
                    }
                    if (remainingItem != null) {
                        StoveBlockEntity.this.m_6836_(this.inputIndex, new ItemStack((ItemLike)remainingItem));
                    }
                }
            }
        }

        @Override
        public boolean canProcess() {
            if (!StoveBlockEntity.this.isNodePowered() || !StoveBlockEntity.this.enabled) {
                return false;
            }
            ItemStack stack = StoveBlockEntity.this.m_8020_(this.inputIndex);
            if (!stack.m_41619_()) {
                Optional<? extends ProcessingRecipe> optional = this.getRecipe();
                if (optional.isEmpty()) {
                    return false;
                }
                Level level = Objects.requireNonNull(StoveBlockEntity.this.m_58904_());
                ItemStack result = optional.get().m_8043_(level.m_9598_());
                return this.canOutput(result);
            }
            return false;
        }

        private boolean canOutput(ItemStack result) {
            if (result.m_41619_()) {
                return false;
            }
            ItemStack stack = StoveBlockEntity.this.m_8020_(this.outputIndex);
            return stack.m_41619_() || ItemStack.m_150942_((ItemStack)result, (ItemStack)stack) && stack.m_41613_() + result.m_41613_() <= stack.m_41741_();
        }

        private Optional<? extends ProcessingRecipe> getRecipe() {
            ItemStack stack = StoveBlockEntity.this.m_8020_(this.inputIndex);
            if (!stack.m_41619_()) {
                Level level = StoveBlockEntity.this.m_58904_();
                return this.inputRecipeCache.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), Objects.requireNonNull(level));
            }
            return Optional.empty();
        }

        public void writeToTag(CompoundTag tag) {
            tag.m_128405_("CookingTime", this.bakingTime);
            tag.m_128405_("TotalCookingTime", this.totalBakingTime);
        }

        public void readFromTag(CompoundTag tag) {
            if (tag.m_128425_("CookingTime", 3)) {
                this.bakingTime = tag.m_128451_("CookingTime");
            }
            if (tag.m_128425_("TotalCookingTime", 3)) {
                this.totalBakingTime = tag.m_128451_("TotalCookingTime");
            }
        }
    }
}

