/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.block.ToasterBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleProcessingLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ToasterBlockEntity
extends ElectricityModuleProcessingLootBlockEntity {
    public static final int[] INPUT_SLOTS = new int[]{0, 1};
    public static final int[] OUTPUT_SLOTS = new int[]{0, 1};
    protected boolean heating;
    protected boolean sync;

    public ToasterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TOASTER.get(), pos, state, 2, (RecipeType<? extends ProcessingRecipe>)((RecipeType)ModRecipeTypes.TOASTER_HEATING.get()));
    }

    public ToasterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int containerSize, RecipeType<? extends ProcessingRecipe> recipeType) {
        super(type, pos, state, containerSize, recipeType);
    }

    @Override
    public void setNodePowered(boolean powered) {
        super.setNodePowered(powered);
        if (!powered && this.isHeating()) {
            this.setHeating(false);
        }
    }

    public void startHeating() {
        if (!this.heating && this.canProcessInput() && this.isNodePowered()) {
            this.setHeating(true);
        }
    }

    public boolean toggleHeating() {
        if (this.heating || this.canProcessInput() && this.isNodePowered()) {
            this.setHeating(!this.heating);
            return true;
        }
        return false;
    }

    private void setHeating(boolean heating) {
        this.heating = heating;
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ToasterBlock.POWERED, (Comparable)Boolean.valueOf(this.heating)), 3);
        this.playLeverSound(heating);
        this.sync();
    }

    public boolean isHeating() {
        return this.heating;
    }

    @Override
    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    public int[] getEnergySlots() {
        return NO_SLOTS;
    }

    @Override
    protected boolean shouldProcessAll() {
        return true;
    }

    @Override
    public boolean canProcess() {
        return this.heating && super.canProcessInput();
    }

    @Override
    public void onCompleteProcess() {
        super.onCompleteProcess();
        this.setHeating(false);
        this.sync();
    }

    @Override
    protected boolean handleProcessed(ItemStack stack) {
        BlockPos pos = this.f_58858_;
        ItemEntity entity = new ItemEntity(this.f_58857_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack.m_41777_());
        entity.m_32060_();
        entity.m_20256_(new Vec3(0.0, 0.35, 0.0));
        this.f_58857_.m_7967_((Entity)entity);
        return true;
    }

    @Override
    public boolean processTick() {
        boolean result = super.processTick();
        if (this.sync) {
            BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
            this.sync = false;
        }
        return result;
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        return false;
    }

    protected Component m_6820_() {
        return Utils.translation("container", "toaster", new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return null;
    }

    @Override
    public boolean m_7013_(int slotIndex, ItemStack stack) {
        return !this.isHeating() && super.m_7013_(slotIndex, stack);
    }

    @Override
    public boolean m_271862_(Container container, int slotIndex, ItemStack stack) {
        return !this.isHeating() && super.m_271862_(container, slotIndex, stack);
    }

    public void m_6596_() {
        super.m_6596_();
        if (!this.f_58857_.m_5776_()) {
            this.sync();
        }
    }

    protected void sync() {
        this.sync = true;
    }

    public boolean insertItem(ItemStack heldItem) {
        if (this.isHeating()) {
            return false;
        }
        if (heldItem.m_41619_() || this.isFull()) {
            return this.extractItem();
        }
        if (this.isRecipe(heldItem)) {
            for (int i = 0; i < this.m_6643_(); ++i) {
                if (!this.m_8020_(i).m_41619_()) continue;
                ItemStack stack = heldItem.m_41777_();
                stack.m_41764_(1);
                heldItem.m_41774_(1);
                this.m_6836_(i, stack);
                this.playInsertSound();
                this.sync();
                return true;
            }
        }
        return false;
    }

    public boolean extractItem() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            BlockPos pos = this.f_58858_;
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack.m_41777_());
            this.m_6836_(i, ItemStack.f_41583_);
            this.f_58857_.m_7967_((Entity)entity);
            this.sync();
            return true;
        }
        return false;
    }

    private boolean isFull() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void playLeverSound(boolean heating) {
        Preconditions.checkNotNull((Object)this.f_58857_);
        SoundEvent event = heating ? (SoundEvent)ModSounds.BLOCK_TOASTER_DOWN.get() : (SoundEvent)ModSounds.BLOCK_TOASTER_POP.get();
        this.f_58857_.m_5594_(null, this.f_58858_, event, SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * this.f_58857_.f_46441_.m_188501_());
    }

    private void playInsertSound() {
        Preconditions.checkNotNull((Object)this.f_58857_);
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.BLOCK_TOASTER_INSERT.get(), SoundSource.BLOCKS, 0.5f, 0.9f + 0.1f * this.f_58857_.f_46441_.m_188501_());
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, ToasterBlockEntity entity) {
        if (((Boolean)state.m_61143_((Property)ToasterBlock.POWERED)).booleanValue()) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0, 0.1 * level.f_46441_.m_188500_(), 0.0);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Heating", 1)) {
            this.heating = tag.m_128471_("Heating");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Heating", this.heating);
    }

    @Override
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

