/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.data.Material;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WorkbenchContructingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final NonNullList<StackedIngredient> materials;
    private final ItemStack result;
    private final boolean notification;

    public WorkbenchContructingRecipe(ResourceLocation id, NonNullList<StackedIngredient> materials, ItemStack result, boolean notification) {
        this.id = id;
        this.materials = materials;
        this.result = result;
        this.notification = notification;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.WORKBENCH_RECIPE.get();
    }

    public boolean m_5818_(Container container, Level level) {
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result;
    }

    public boolean m_271738_() {
        return this.notification;
    }

    public NonNullList<StackedIngredient> getMaterials() {
        return this.materials;
    }

    public int getResultId() {
        return Item.m_41393_((Item)this.result.m_41720_());
    }

    public ItemStack getResult() {
        return this.result;
    }

    public static Builder builder(ItemLike result, int count, Function<ItemLike, CriterionTriggerInstance> hasItem, Function<TagKey<Item>, CriterionTriggerInstance> hasTag) {
        return new Builder(result.m_5456_(), count, hasItem, hasTag);
    }

    public static class Builder
    implements RecipeBuilder {
        private final Item result;
        private final int count;
        private final Function<ItemLike, CriterionTriggerInstance> hasItem;
        private final Function<TagKey<Item>, CriterionTriggerInstance> hasTag;
        private final List<StackedIngredient> materials = new ArrayList<StackedIngredient>();
        private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
        private RecipeCategory category = RecipeCategory.MISC;
        private boolean showNotification;

        private Builder(Item result, int count, Function<ItemLike, CriterionTriggerInstance> hasItem, Function<TagKey<Item>, CriterionTriggerInstance> hasTag) {
            this.result = result;
            this.count = count;
            this.hasItem = hasItem;
            this.hasTag = hasTag;
        }

        public Builder requiresMaterial(Material<?> material) {
            this.materials.add(material.asStackedIngredient());
            return this.unlockedBy("has_" + material.getName(), material.createTrigger(this.hasItem, this.hasTag));
        }

        public Builder unlockedBy(String name, CriterionTriggerInstance trigger) {
            this.advancement.m_138386_(name, trigger);
            return this;
        }

        public Builder group(@Nullable String group) {
            return this;
        }

        public Builder category(RecipeCategory category) {
            this.category = category;
            return this;
        }

        public Builder showNotification(boolean show) {
            this.showNotification = show;
            return this;
        }

        public Item m_142372_() {
            return this.result;
        }

        public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            this.validate(id);
            this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
            consumer.accept(new Result(id, this.result, this.count, this.materials, this.advancement, id.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.showNotification));
        }

        private void validate(ResourceLocation id) {
            if (this.materials.isEmpty()) {
                throw new IllegalArgumentException("There must be at least one material for workbench crafting recipe %s".formatted(id));
            }
            if (this.advancement.m_138405_().isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + id);
            }
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final List<StackedIngredient> materials;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final boolean notification;

        public Result(ResourceLocation id, Item result, int count, List<StackedIngredient> materials, Advancement.Builder advancement, ResourceLocation advancementId, boolean notification) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.materials = materials;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.notification = notification;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.WORKBENCH_RECIPE.get();
        }

        public void m_7917_(JsonObject object) {
            Serializer.toJson(this, object);
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }

    public static class Serializer
    implements RecipeSerializer<WorkbenchContructingRecipe> {
        public static void toJson(Result result, JsonObject object) {
            JsonArray materialsArray = new JsonArray();
            for (StackedIngredient ingredient : result.materials) {
                materialsArray.add(ingredient.toJson());
            }
            object.add("materials", (JsonElement)materialsArray);
            if (result.count == 1) {
                object.addProperty("result", BuiltInRegistries.f_257033_.m_7981_((Object)result.result).toString());
            } else {
                JsonObject itemObject = new JsonObject();
                itemObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)result.result).toString());
                itemObject.addProperty("count", (Number)result.count);
                object.add("result", (JsonElement)itemObject);
            }
            object.addProperty("show_notification", Boolean.valueOf(result.notification));
        }

        public WorkbenchContructingRecipe fromJson(ResourceLocation id, JsonObject object) {
            JsonArray materialArray = GsonHelper.m_13933_((JsonObject)object, (String)"materials");
            NonNullList materials = NonNullList.m_122780_((int)materialArray.size(), (Object)StackedIngredient.EMPTY);
            IntStream.range(0, materialArray.size()).forEach(i -> materials.set(i, (Object)StackedIngredient.fromJson(materialArray.get(i))));
            ItemStack result = Utils.getItemStack(object, "result");
            boolean notification = GsonHelper.m_13855_((JsonObject)object, (String)"show_notification", (boolean)true);
            return new WorkbenchContructingRecipe(id, (NonNullList<StackedIngredient>)materials, result, notification);
        }

        public WorkbenchContructingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int materialCount = buffer.readInt();
            NonNullList materials = NonNullList.m_122780_((int)materialCount, (Object)StackedIngredient.EMPTY);
            IntStream.range(0, materialCount).forEach(value -> materials.set(value, (Object)StackedIngredient.fromNetwork(buffer)));
            ItemStack result = buffer.m_130267_();
            boolean notification = buffer.readBoolean();
            return new WorkbenchContructingRecipe(id, (NonNullList<StackedIngredient>)materials, result, notification);
        }

        public void toNetwork(FriendlyByteBuf buffer, WorkbenchContructingRecipe recipe) {
            buffer.writeInt(recipe.materials.size());
            recipe.materials.forEach(ingredient -> ingredient.toNetwork(buffer));
            buffer.m_130055_(recipe.result);
            buffer.writeBoolean(recipe.notification);
        }
    }
}

