/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.BreakParticleRenderer;
import net.tejty.gamediscs.games.graphics.DirectionalImage;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Particle;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.games.util.Sprite;
import net.tejty.gamediscs.games.util.VecUtil;

public class SlimeGame
extends Game {
    private final DirectionalImage HEAD = new DirectionalImage(new ResourceLocation("gamediscs:textures/games/sprite/slime_head.png"), 8, 32);
    private final DirectionalImage TAIL = new DirectionalImage(new ResourceLocation("gamediscs:textures/games/sprite/slime_tail.png"), 8, 32);
    private final DirectionalImage CONNECTION = new DirectionalImage(new ResourceLocation("gamediscs:textures/games/sprite/slime_connection.png"), 8, 32);
    private static final ResourceLocation BODY = new ResourceLocation("gamediscs:textures/games/sprite/slime_body.png");
    private static final ResourceLocation APPLE = new ResourceLocation("gamediscs:textures/games/sprite/apple.png");
    private static final Vec2 GAME_POS = new Vec2(6.0f, 2.0f);
    private static final int TILE_SIZE = 8;
    private static final int GAME_WIDTH = 16;
    private static final int GAME_HEIGHT = 12;
    private static final List<Vec2> BLOCKED = List.of(new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(2.0f, 0.0f), new Vec2(3.0f, 0.0f), new Vec2(4.0f, 0.0f), new Vec2(5.0f, 0.0f), new Vec2(6.0f, 0.0f));
    private List<Vec2> slime = new ArrayList<Vec2>();
    private Vec2 direction = VecUtil.VEC_RIGHT;
    private final Sprite slimeRenderer = new Sprite(Vec2.f_82462_, new Vec2(8.0f, 8.0f), BODY);
    private final Sprite apple = new Sprite(Vec2.f_82462_, new Vec2(8.0f, 8.0f), APPLE);

    @Override
    public synchronized void prepare() {
        super.prepare();
        this.slime = new ArrayList<Vec2>();
        this.slime.add(new Vec2(5.0f, 5.0f));
        this.slime.add(new Vec2(6.0f, 5.0f));
        this.slime.add(new Vec2(7.0f, 5.0f));
        this.respawnApple();
    }

    @Override
    public synchronized void start() {
        super.start();
        this.direction = VecUtil.VEC_RIGHT;
    }

    @Override
    public synchronized void gameTick() {
        super.gameTick();
        Vec2 newPos = this.slime.get(this.slime.size() - 1).m_165910_(this.direction);
        if (newPos.f_82470_ >= 16.0f || newPos.f_82470_ < 0.0f || newPos.f_82471_ >= 12.0f || newPos.f_82471_ < 0.0f) {
            this.die();
        }
        for (int i = 0; i < this.slime.size(); ++i) {
            Vec2 part = this.slime.get(i);
            if (i == 0 || !VecUtil.is(part, newPos)) continue;
            this.die();
        }
        for (Vec2 block : BLOCKED) {
            if (!VecUtil.is(block, newPos)) continue;
            this.die();
        }
        if (this.stage == GameStage.PLAYING) {
            this.slime.add(newPos);
            if (!VecUtil.is(newPos, this.calcTile(this.apple.getPos()))) {
                this.slime.remove(this.slime.get(0));
            } else {
                this.spawnParticleExplosion(() -> new BreakParticleRenderer(APPLE, 8, 8), this.apple.getCenterPos(), 15, 3, 5, ParticleLevel.GAME);
                this.respawnApple();
                ++this.score;
                this.soundPlayer.play(SoundEvents.f_11912_);
            }
        }
        this.addParticle(new Particle(this.calcPos(this.slime.get(0).m_165910_(VecUtil.randomFloat(Vec2.f_82462_, new Vec2(1.0f, 1.0f), this.random))), new BreakParticleRenderer(BODY, 8, 8), this.random.nextInt(20, 50), ParticleLevel.RUNNING_GAME));
    }

    @Override
    public synchronized void render(GuiGraphics graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        this.apple.render(graphics, posX, posY);
        this.renderParticles(graphics, posX, posY);
        for (int i = this.slime.size() - 1; i >= 0; --i) {
            if (i == 0) {
                this.slimeRenderer.setImage(this.TAIL.setImage(VecUtil.get4DirectionTo(this.slime.get(0), this.slime.get(1))));
            } else if (i == this.slime.size() - 1) {
                this.slimeRenderer.setImage(this.HEAD.setImage(VecUtil.get4DirectionTo(this.slime.get(this.slime.size() - 2), this.slime.get(this.slime.size() - 1))));
            } else {
                this.slimeRenderer.setImage(BODY);
            }
            Vec2 part = this.slime.get(i);
            this.slimeRenderer.setPos(this.calcPos(part));
            this.slimeRenderer.render(graphics, posX, posY);
            if (i + 1 >= this.slime.size()) continue;
            this.slimeRenderer.setPos(this.calcPos(part.m_165910_(VecUtil.getFrom(VecUtil.get4DirectionTo(part, this.slime.get(i + 1))).m_165903_(0.5f))));
            this.slimeRenderer.setImage(this.CONNECTION.setImage(VecUtil.get4DirectionTo(part, this.slime.get(i + 1))));
            this.slimeRenderer.render(graphics, posX, posY);
        }
        this.renderOverlay(graphics, posX, posY);
    }

    private void respawnApple() {
        boolean valid = false;
        block0: while (!valid) {
            this.apple.setPos(this.calcPos(VecUtil.randomInt(Vec2.f_82462_, new Vec2(16.0f, 12.0f), this.random)));
            valid = true;
            Vec2 applePos = this.calcTile(this.apple.getPos());
            for (Vec2 vec2 : this.slime) {
                if (!VecUtil.is(vec2, applePos)) continue;
                valid = false;
                break;
            }
            for (Vec2 block : BLOCKED) {
                if (!VecUtil.is(block, applePos)) continue;
                valid = false;
                continue block0;
            }
        }
    }

    private Vec2 calcTile(Vec2 pos) {
        return pos.m_165910_(GAME_POS.m_165913_()).m_165903_(0.125f);
    }

    private Vec2 calcPos(Vec2 tile) {
        return tile.m_165903_(8.0f).m_165910_(GAME_POS);
    }

    @Override
    public synchronized void buttonDown(Button button) {
        super.buttonDown(button);
        if (this.stage == GameStage.PLAYING) {
            Vec2 oldDirection = this.direction;
            switch (button) {
                case UP: {
                    this.direction = VecUtil.VEC_UP;
                    break;
                }
                case RIGHT: {
                    this.direction = VecUtil.VEC_RIGHT;
                    break;
                }
                case DOWN: {
                    this.direction = VecUtil.VEC_DOWN;
                    break;
                }
                case LEFT: {
                    this.direction = VecUtil.VEC_LEFT;
                }
            }
            if (!VecUtil.is(oldDirection, this.direction)) {
                this.soundPlayer.play(SoundEvents.f_12388_, 0.1f, 0.5f);
            }
        }
    }

    @Override
    public int gameTickDuration() {
        return 5;
    }

    @Override
    public ResourceLocation getBackground() {
        return new ResourceLocation("gamediscs:textures/games/background/slime_background.png");
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"gamediscs.slime");
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("gamediscs:textures/item/game_disc_slime.png");
    }
}

