/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.util;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.gamediscs.BlocktrisGame;
import net.tejty.gamediscs.games.util.Grid;

public class BlocktrisPiece {
    private final List<List<Vec2>> variants;
    private final BlocktrisGame game;
    private int x;
    private int y;
    private int rotation;
    private int color;
    private final Grid grid;
    private List<Vec2> altPositions = List.of(new Vec2(0.0f, 1.0f), new Vec2(-1.0f, 1.0f), new Vec2(1.0f, 1.0f), new Vec2(-1.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, -1.0f), new Vec2(-1.0f, -1.0f), new Vec2(1.0f, -1.0f));
    public static final Supplier<List<List<Vec2>>> TRIANGLE = () -> List.of(List.of(new Vec2(0.0f, 0.0f), new Vec2(0.0f, -1.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 1.0f)), List.of(new Vec2(0.0f, 0.0f), new Vec2(-1.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 1.0f)), List.of(new Vec2(0.0f, 0.0f), new Vec2(0.0f, -1.0f), new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 1.0f)), List.of(new Vec2(0.0f, 0.0f), new Vec2(0.0f, -1.0f), new Vec2(1.0f, 0.0f), new Vec2(-1.0f, 0.0f)));
    public static final Supplier<List<List<Vec2>>> J = () -> List.of(List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(-1.0f, 1.0f)), List.of(new Vec2(-1.0f, -1.0f), new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f)), List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, -1.0f)), List.of(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(1.0f, 1.0f)));
    public static final Supplier<List<List<Vec2>>> LINE = () -> List.of(List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(0.0f, 2.0f)), List.of(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(2.0f, 0.0f)));
    public static final Supplier<List<List<Vec2>>> Z = () -> List.of(List.of(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(-1.0f, 1.0f), new Vec2(0.0f, -1.0f)), List.of(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f)));
    public static final Supplier<List<List<Vec2>>> SQUARE = () -> List.of(List.of(new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f)));
    public static final Supplier<List<List<Vec2>>> L = () -> List.of(List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f)), List.of(new Vec2(-1.0f, 1.0f), new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f)), List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(-1.0f, -1.0f)), List.of(new Vec2(-1.0f, 0.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(1.0f, -1.0f)));
    public static final Supplier<List<List<Vec2>>> S = () -> List.of(List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, 0.0f), new Vec2(1.0f, 1.0f)), List.of(new Vec2(0.0f, -1.0f), new Vec2(0.0f, 0.0f), new Vec2(1.0f, -1.0f), new Vec2(-1.0f, 0.0f)));
    public static final List<Supplier<List<List<Vec2>>>> PIECES = List.of(TRIANGLE, J, LINE, Z, SQUARE, L, S);

    public BlocktrisPiece(List<List<Vec2>> variants, int x, int y, int color, BlocktrisGame game) {
        this.variants = variants;
        this.x = x;
        this.y = y;
        this.color = color;
        this.grid = game.grid;
        this.game = game;
    }

    public List<Vec2> current() {
        return this.variants.get(this.rotation);
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean isTouching() {
        for (Vec2 part : this.current()) {
            if (part.f_82470_ + (float)this.x >= (float)this.grid.width() || part.f_82470_ + (float)this.x < 0.0f || part.f_82471_ + (float)this.y >= (float)this.grid.height() || part.f_82471_ + (float)this.y < 0.0f) {
                return true;
            }
            if (this.grid.get((int)part.f_82470_ + this.x, (int)part.f_82471_ + this.y) == 0) continue;
            return true;
        }
        return false;
    }

    public void rotate() {
        block3: {
            ++this.rotation;
            if (this.rotation >= this.variants.size()) {
                this.rotation = 0;
            }
            if (!this.isTouching()) break block3;
            int oldX = this.x;
            int oldY = this.y;
            int i = 0;
            do {
                this.x = oldX;
                this.y = oldY;
                this.x = (int)((float)this.x + this.altPositions.get((int)i).f_82470_);
                this.y = (int)((float)this.y + this.altPositions.get((int)i).f_82471_);
                if (!this.isTouching()) break block3;
            } while (++i < this.altPositions.size());
            this.x = oldX;
            this.y = oldY;
            --this.rotation;
            if (this.rotation < 0) {
                this.rotation = this.variants.size() - 1;
            }
        }
    }

    public boolean move(int x, int y) {
        boolean flag = false;
        this.x += x;
        if (this.isTouching()) {
            this.x -= x;
            flag = true;
        }
        this.y += y;
        if (this.isTouching()) {
            this.y -= y;
            flag = true;
        }
        return flag;
    }

    public void hardDrop() {
        while (!this.move(0, 1)) {
        }
    }

    public void place() {
        for (Vec2 part : this.current()) {
            this.grid.set(this.x + (int)part.f_82470_, this.y + (int)part.f_82471_, this.color + 1);
        }
    }

    public void tick() {
        ++this.y;
    }

    public void render(GuiGraphics graphics, int posX, int posY) {
        this.grid.getImages().setImage(this.color + 1);
        for (Vec2 part : this.current()) {
            this.grid.getImages().render(graphics, posX + (this.x + (int)part.f_82470_) * this.grid.tileSize(), posY + (this.y + (int)part.f_82471_) * this.grid.tileSize());
        }
    }

    public void renderCentered(GuiGraphics graphics, int posX, int posY) {
        this.grid.getImages().setImage(this.color + 1);
        Vec2 smallest = null;
        Vec2 biggest = null;
        for (int i = 0; i < this.current().size(); ++i) {
            Vec2 part = this.current().get(i);
            if (smallest == null) {
                smallest = part;
            }
            if (biggest == null) {
                biggest = part;
            }
            smallest = new Vec2(Math.min(smallest.f_82470_, part.f_82470_), Math.min(smallest.f_82471_, part.f_82471_));
            biggest = new Vec2(Math.max(biggest.f_82470_, part.f_82470_), Math.max(biggest.f_82471_, part.f_82471_));
        }
        Vec2 addition = smallest.m_165910_(biggest.m_165913_()).m_165903_(0.5f).m_165910_(biggest).m_165913_();
        for (Vec2 part : this.current()) {
            this.grid.getImages().render(graphics, posX + (int)(((float)this.x + part.f_82470_ + addition.f_82470_) * (float)this.grid.tileSize()), posY + (int)(((float)(this.y + (int)part.f_82471_) + addition.f_82471_) * (float)this.grid.tileSize()));
        }
    }

    public void setRotation(int direction) {
        this.rotation = direction;
        if (this.rotation >= this.variants.size()) {
            this.rotation = this.variants.size() - 1;
        }
        if (this.rotation < 0) {
            this.rotation = 0;
        }
    }
}

