/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tejty.gamediscs.games.audio.SoundPlayer;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.controls.Controls;
import net.tejty.gamediscs.games.graphics.ParticleColor;
import net.tejty.gamediscs.games.graphics.Renderer;
import net.tejty.gamediscs.games.util.ConfettiParticle;
import net.tejty.gamediscs.games.util.ExplosionParticle;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Particle;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.item.ItemRegistry;
import net.tejty.gamediscs.item.custom.GamingConsoleItem;
import net.tejty.gamediscs.sounds.SoundRegistry;
import net.tejty.gamediscs.util.networking.ModMessages;
import net.tejty.gamediscs.util.networking.packet.SetBestScoreC2SPacket;

public class Game {
    public GameStage stage = GameStage.START;
    public Controls controls = new Controls(this);
    public SoundPlayer soundPlayer = new SoundPlayer();
    public static final int WIDTH = 140;
    public static final int HEIGHT = 100;
    public final Random random = new Random();
    public int ticks = 0;
    public int score = 0;
    public int lives = this.maxLives();
    private List<Particle> particles = new ArrayList<Particle>();

    public int maxLives() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void prepare() {
        this.score = 0;
        this.lives = this.maxLives();
        this.respawn();
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void start() {
        this.stage = GameStage.PLAYING;
        this.ticks = 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void die() {
        if (this.getConsole().m_41720_() instanceof GamingConsoleItem) {
            String gameName = this.getClass().getName().substring(this.getClass().getPackageName().length() + 1);
            if (GamingConsoleItem.getBestScore(this.getConsole(), gameName, (Player)Minecraft.m_91087_().f_91074_) < this.score) {
                ModMessages.sendToServer(new SetBestScoreC2SPacket(gameName, this.score));
                this.soundPlayer.playNewBest();
                this.spawnConfetti();
            } else {
                this.soundPlayer.playGameOver();
            }
        }
        this.stage = GameStage.DIED;
        this.ticks = 1;
    }

    public synchronized void lostLife() {
        --this.lives;
        this.soundPlayer.play((SoundEvent)SoundRegistry.EXPLOSION.get());
        this.respawn();
        if (this.lives <= 0) {
            this.die();
        }
    }

    public synchronized void respawn() {
        this.stage = GameStage.START;
        this.ticks = 1;
        this.particles.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void win() {
        this.soundPlayer.playNewBest();
        this.spawnConfetti();
        if (this.getConsole().m_41720_() instanceof GamingConsoleItem) {
            String gameName = this.getClass().getName().substring(this.getClass().getPackageName().length() + 1);
            if (GamingConsoleItem.getBestScore(this.getConsole(), gameName, (Player)Minecraft.m_91087_().f_91074_) < this.score) {
                ModMessages.sendToServer(new SetBestScoreC2SPacket(gameName, this.score));
            }
        }
        this.stage = GameStage.WON;
        this.ticks = 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ItemStack getConsole() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        assert (player != null);
        ItemStack item = player.m_21205_();
        if (item.m_41720_() instanceof GamingConsoleItem) {
            return item;
        }
        item = player.m_21206_();
        if (item.m_41720_() instanceof GamingConsoleItem) {
            return item;
        }
        return new ItemStack((ItemLike)ItemRegistry.GAMING_CONSOLE.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void tick() {
        if (this.stage == GameStage.PLAYING && this.ticks % this.gameTickDuration() == 0) {
            this.gameTick();
        }
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = this.particles.get(i);
            particle.tick();
            if (!particle.isDead()) continue;
            this.particles.remove(i);
            --i;
        }
        ++this.ticks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void gameTick() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void render(GuiGraphics graphics, int posX, int posY) {
        if (this.getBackground() != null) {
            graphics.m_280398_(this.getBackground(), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
        }
        this.renderOverlay(graphics, posX, posY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void renderOverlay(GuiGraphics graphics, int posX, int posY) {
        Font font = Minecraft.m_91087_().f_91062_;
        if (this.stage != GameStage.PLAYING) {
            if (this.showPressAnyKey()) {
                MutableComponent mutableComponent = Component.m_237115_((String)"gui.gamingconsole.press_any_key");
                int n = posX + (140 - font.m_92724_(Component.m_237115_((String)"gui.gamingconsole.press_any_key").m_7532_())) / 2 + 1;
                Objects.requireNonNull(font);
                graphics.m_280614_(font, (Component)mutableComponent, n, posY + 100 - 9 - 1, 0x373737, false);
                MutableComponent mutableComponent2 = Component.m_237115_((String)"gui.gamingconsole.press_any_key");
                int n2 = posX + (140 - font.m_92724_(Component.m_237115_((String)"gui.gamingconsole.press_any_key").m_7532_())) / 2;
                Objects.requireNonNull(font);
                graphics.m_280614_(font, (Component)mutableComponent2, n2, posY + 100 - 9 - 2, 0xFFFFFF, false);
            }
            if (this.stage == GameStage.DIED || this.stage == GameStage.WON) {
                graphics.m_280398_(new ResourceLocation("gamediscs:textures/gui/score_board.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
                MutableComponent component = this.stage == GameStage.DIED ? Component.m_237115_((String)"gui.gamingconsole.died").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_RED}) : Component.m_237115_((String)"gui.gamingconsole.won").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GREEN});
                graphics.m_280614_(font, (Component)component, posX + (140 - font.m_92724_(component.m_7532_())) / 2, posY + 29, Objects.requireNonNull(component.m_7383_().m_131135_()).m_131265_(), false);
                graphics.m_280614_(font, (Component)component, posX + (140 - font.m_92724_(component.m_7532_())) / 2, posY + 31, component.m_7383_().m_131135_().m_131265_(), false);
                graphics.m_280614_(font, (Component)component, posX + (140 - font.m_92724_(component.m_7532_())) / 2 + 1, posY + 30, component.m_7383_().m_131135_().m_131265_(), false);
                graphics.m_280614_(font, (Component)component, posX + (140 - font.m_92724_(component.m_7532_())) / 2 - 1, posY + 30, component.m_7383_().m_131135_().m_131265_(), false);
                component = this.stage == GameStage.DIED ? Component.m_237115_((String)"gui.gamingconsole.died").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}) : Component.m_237115_((String)"gui.gamingconsole.won").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN});
                graphics.m_280614_(font, (Component)component, posX + (140 - font.m_92724_(component.m_7532_())) / 2, posY + 30, Objects.requireNonNull(component.m_7383_().m_131135_()).m_131265_(), false);
                component = Component.m_237115_((String)"gui.gamingconsole.score").m_130946_(": ").m_130946_(String.valueOf(this.score)).m_130940_(ChatFormatting.YELLOW);
                int n = posX + (140 - font.m_92724_(component.m_7532_())) / 2;
                Objects.requireNonNull(font);
                graphics.m_280614_(font, (Component)component, n, posY + 35 + 9, Objects.requireNonNull(component.m_7383_().m_131135_()).m_131265_(), false);
                int bestScore = GamingConsoleItem.getBestScore(this.getConsole(), this.getClass().getName().substring(this.getClass().getPackageName().length() + 1), (Player)Minecraft.m_91087_().f_91074_);
                component = Component.m_237115_((String)(this.score >= bestScore ? "gui.gamingconsole.new_best_score" : "gui.gamingconsole.best_score")).m_130946_(": ").m_130946_(String.valueOf(bestScore)).m_130940_(this.score >= bestScore ? ChatFormatting.GREEN : ChatFormatting.YELLOW);
                int n3 = posX + (140 - font.m_92724_(component.m_7532_())) / 2;
                Objects.requireNonNull(font);
                graphics.m_280614_(font, (Component)component, n3, posY + 50 + 9, Objects.requireNonNull(component.m_7383_().m_131135_()).m_131265_(), false);
            }
        } else {
            if (this.showScoreBox() && this.showScore()) {
                graphics.m_280398_(new ResourceLocation("gamediscs:textures/gui/score_box.png"), posX, posY, 0, 0.0f, 0.0f, 140, 100, 140, 100);
            }
            if (this.showScore()) {
                graphics.m_280614_(font, (Component)(this.scoreText() ? Component.m_237115_((String)"gui.gamingconsole.score").m_130946_(": ") : Component.m_237119_()).m_130946_(String.valueOf(this.score)), posX + 2, posY + 2, 0x373737, false);
                graphics.m_280614_(font, (Component)(this.scoreText() ? Component.m_237115_((String)"gui.gamingconsole.score").m_130946_(": ") : Component.m_237119_()).m_130946_(String.valueOf(this.score)), posX + 1, posY + 1, this.scoreColor(), false);
            }
        }
        for (Particle particle : this.particles) {
            if (!particle.isForOverlay()) continue;
            particle.render(graphics, posX, posY, this.stage);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void renderParticles(GuiGraphics graphics, int posX, int posY) {
        for (Particle particle : this.particles) {
            particle.render(graphics, posX, posY, this.stage);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void buttonDown(Button button) {
        this.soundPlayer.playClick(true);
        if ((this.stage == GameStage.START || this.stage == GameStage.RETRY) && this.ticks > 8) {
            this.start();
        } else if ((this.stage == GameStage.WON || this.stage == GameStage.DIED) && this.ticks > 8) {
            this.prepare();
        }
    }

    public Particle addParticle(Particle particle) {
        this.particles.add(particle);
        return particle;
    }

    public void spawnParticleExplosion(Supplier<Renderer> renderer, Vec2 pos, int count, int speed, int lifetime, ParticleLevel level) {
        for (int i = 0; i < count; ++i) {
            Particle particle = new Particle(pos, renderer.get(), this.random.nextInt(lifetime / 2, lifetime), level);
            particle.setVelocity(new Vec2(this.random.nextFloat(-speed, speed), this.random.nextFloat(-speed, speed)));
            this.particles.add(particle);
        }
    }

    public void spawnParticleExplosion(Vec2 pos, int count, int speed, int lifetime, ParticleLevel level) {
        this.soundPlayer.play(SoundEvents.f_11913_, 1.5f, 0.1f);
        for (int i = 0; i < count; ++i) {
            ExplosionParticle particle = new ExplosionParticle(pos, this.random.nextInt(lifetime / 2, lifetime), level);
            particle.setVelocity(new Vec2(this.random.nextFloat(-speed, speed), this.random.nextFloat(-speed, speed)));
            this.particles.add(particle);
        }
    }

    public void spawnConfetti() {
        ConfettiParticle particle;
        int i;
        for (i = 0; i < 30; ++i) {
            particle = new ConfettiParticle(new Vec2(0.0f, 100.0f), ParticleColor.random(this.random), this.random.nextInt(50, 70), ParticleLevel.OVERLAY);
            particle.setVelocity(new Vec2(this.random.nextFloat(1.0f, 10.0f), this.random.nextFloat(-25.0f, -10.0f)));
            this.particles.add(particle);
        }
        for (i = 0; i < 30; ++i) {
            particle = new ConfettiParticle(new Vec2(140.0f, 100.0f), ParticleColor.random(this.random), this.random.nextInt(50, 70), ParticleLevel.OVERLAY);
            particle.setVelocity(new Vec2(this.random.nextFloat(-10.0f, -1.0f), this.random.nextFloat(-25.0f, -10.0f)));
            this.particles.add(particle);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public synchronized void buttonUp(Button button) {
        this.soundPlayer.playClick(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int gameTickDuration() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getBackground() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean showScoreBox() {
        return true;
    }

    public boolean showScore() {
        return true;
    }

    public boolean showPressAnyKey() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int scoreColor() {
        return 0xFFFFFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean scoreText() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName() {
        return Component.m_237119_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getIcon() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChatFormatting getColor() {
        return ChatFormatting.YELLOW;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEmpty() {
        return this.getClass().equals(Game.class);
    }
}

